/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.smartkeeper.api;

import java.io.IOException;
import retrofit.http.Body;
import retrofit.http.DELETE;
import retrofit.http.GET;
import retrofit.http.POST;
import retrofit.http.PUT;
import retrofit.http.Path;
import retrofit.http.Query;
import ru.softlogic.keeper.api.model.DTOAnonymousResponse;
import ru.softlogic.keeper.api.model.DTOHistory;
import ru.softlogic.keeper.api.model.DTOHistoryChange;
import ru.softlogic.keeper.api.model.DTOLongList;
import ru.softlogic.keeper.api.model.DTOResponse;
import ru.softlogic.keeper.api.model.autopayment.DTOAutoPayment;
import ru.softlogic.keeper.api.model.autopayment.DTOAutoPaymentResponse;
import ru.softlogic.keeper.api.model.autopayment.DTOAutoPaymentsResponse;
import ru.softlogic.keeper.api.model.autopayment.DTOBlankAutoPayment;
import ru.softlogic.keeper.api.model.autopayment.DTOConfirmAutopayment;
import ru.softlogic.keeper.api.model.bill.DTOBillPagerResponse;
import ru.softlogic.keeper.api.model.bill.DTOBills;
import ru.softlogic.keeper.api.model.bill.DTOClientBill;
import ru.softlogic.keeper.api.model.bill.DTONewClientBillResponse;
import ru.softlogic.keeper.api.model.cashsource.DTOBalanceResponse;
import ru.softlogic.keeper.api.model.client.DTOInfoResponse;
import ru.softlogic.keeper.api.model.client.DTOInternalMessage;
import ru.softlogic.keeper.api.model.client.DTOLogin;
import ru.softlogic.keeper.api.model.client.DTOLoginAnonymous;
import ru.softlogic.keeper.api.model.client.DTOLoginConfirm;
import ru.softlogic.keeper.api.model.client.DTOLoginResponse;
import ru.softlogic.keeper.api.model.client.DTOMessagePagerResponse;
import ru.softlogic.keeper.api.model.client.DTONotificationsInfoResponse;
import ru.softlogic.keeper.api.model.client.DTORecovery;
import ru.softlogic.keeper.api.model.client.DTORecoveryResponse;
import ru.softlogic.keeper.api.model.client.DTORegistration;
import ru.softlogic.keeper.api.model.client.DTORegistrationResponse;
import ru.softlogic.keeper.api.model.client.DTORegistrationStatusResponse;
import ru.softlogic.keeper.api.model.client.DTOSRecovery;
import ru.softlogic.keeper.api.model.client.DTOSecureLoginResponse;
import ru.softlogic.keeper.api.model.event.DTOClientEvent;
import ru.softlogic.keeper.api.model.event.DTOFeedback;
import ru.softlogic.keeper.api.model.news.DTONewsPagerResponse;
import ru.softlogic.keeper.api.model.online.advanced.DTOAdvanced;
import ru.softlogic.keeper.api.model.online.advanced.DTOAdvancedResponse;
import ru.softlogic.keeper.api.model.operation.DTOCheckResponse;
import ru.softlogic.keeper.api.model.operation.DTOConfirmOperation;
import ru.softlogic.keeper.api.model.operation.DTOHistoryChangeResponse;
import ru.softlogic.keeper.api.model.operation.DTOHistoryPagerResponse;
import ru.softlogic.keeper.api.model.operation.DTOPayment;
import ru.softlogic.keeper.api.model.operation.DTOPaymentResponse;
import ru.softlogic.keeper.api.model.options.DTOAccountLimitResponse;
import ru.softlogic.keeper.api.model.options.DTOChangeNumberResponse;
import ru.softlogic.keeper.api.model.options.DTOChangePasswordResponse;
import ru.softlogic.keeper.api.model.options.DTOCloseResponse;
import ru.softlogic.keeper.api.model.options.DTOPrivateResponse;
import ru.softlogic.keeper.api.model.options.DTORequestEmailChangeResponse;
import ru.softlogic.keeper.api.model.options.DTOSaveSubscribeResponse;
import ru.softlogic.keeper.api.model.options.DTOSubscribeResponse;
import ru.softlogic.keeper.api.model.options.domain.DTOAccountLimitInfoSecure;
import ru.softlogic.keeper.api.model.options.domain.DTOChangeLoginType;
import ru.softlogic.keeper.api.model.options.domain.DTOChangeNumber;
import ru.softlogic.keeper.api.model.options.domain.DTOChangePassword;
import ru.softlogic.keeper.api.model.options.domain.DTOChangePayPasswordSecure;
import ru.softlogic.keeper.api.model.options.domain.DTOChangeSecretKey;
import ru.softlogic.keeper.api.model.options.domain.DTOEmailChange;
import ru.softlogic.keeper.api.model.options.domain.DTOPrivate;
import ru.softlogic.keeper.api.model.options.domain.DTOSubscribeSave;
import ru.softlogic.keeper.api.model.pin.DTOPinConfirm;
import ru.softlogic.keeper.api.model.points.DTOPointPagerResponse;
import ru.softlogic.keeper.api.model.reference.DTOFormReferenceResponse;
import ru.softlogic.keeper.api.model.reference.DTOPointsResponse;
import ru.softlogic.keeper.api.model.reference.DTOReferenceResponse;
import ru.softlogic.keeper.api.model.reference.DTOScenarioReferenceResponse;
import ru.softlogic.keeper.api.model.subscriptions.DTOAddressInfoResponse;
import ru.softlogic.keeper.api.model.subscriptions.DTORegistrationExtended;
import ru.softlogic.keeper.api.model.subscriptions.DTOSubsBillsAllResponse;
import ru.softlogic.keeper.api.model.subscriptions.DTOSubscription;
import ru.softlogic.keeper.api.model.subscriptions.DTOSubscriptionBillsResponse;
import ru.softlogic.keeper.api.model.subscriptions.DTOSubscriptionIdResponse;
import ru.softlogic.keeper.api.model.subscriptions.DTOSubscriptionInfoResponse;
import ru.softlogic.keeper.api.model.template.DTOBlankTemplate;
import ru.softlogic.keeper.api.model.template.DTOTemplate;
import ru.softlogic.keeper.api.model.template.DTOTemplateResponse;
import ru.softlogic.keeper.api.model.template.DTOTemplatesResponse;
import ru.softlogic.smartkeeper.api.dto.DTOFileReferenceNotParsedResponse;
import ru.softlogic.smartkeeper.api.exception.KeeperApiException;

public interface KeeperApi {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 30000;
    public static final int MAX_RETIES_COUNT = 3;
    public static final boolean DEFAULT_IS_LOG_ENABLED = false;
    public static final String DEFAULT_API_VERSION = "1.0.13.0";
    public static final boolean VERIFY_HOSTNAME = true;
    public static final String API_CONTEXT_ROOT = "/keeper-api";

    @GET(value="/system/reference")
    public DTOReferenceResponse getReferences(@Query(value="ignore_file_reference_contents") boolean var1, @Query(value="nopoints") boolean var2) throws KeeperApiException, IOException;

    @POST(value="/clients/registration")
    public DTORegistrationResponse createAccount(@Body DTORegistration var1) throws KeeperApiException, IOException;

    @POST(value="/clients/loginAnonymous")
    public DTOLoginResponse loginAnonymous(@Body DTOLoginAnonymous var1) throws KeeperApiException, IOException;

    @POST(value="/clients/login")
    public DTOLoginResponse login(@Body DTOLogin var1) throws KeeperApiException, IOException;

    @PUT(value="/clients/srecovery")
    public DTORecoveryResponse recoverPasswordSecure(@Body DTOSRecovery var1) throws KeeperApiException, IOException;

    @PUT(value="/clients/recovery")
    public DTORecoveryResponse recoverPassword(@Body DTORecovery var1) throws KeeperApiException, IOException;

    @POST(value="/clients/{client}/payment")
    public DTOPaymentResponse createPayment(@Path(value="client") long var1, @Body DTOPayment var3) throws KeeperApiException, IOException;

    @POST(value="/clients/{client}/history/change")
    public DTOHistoryChangeResponse getOperations(@Path(value="client") long var1, @Body DTOHistoryChange var3) throws KeeperApiException, IOException;

    @POST(value="/clients/{client}/history")
    public DTOHistoryPagerResponse getOperationsPager(@Path(value="client") long var1, @Body DTOHistory var3) throws KeeperApiException, IOException;

    @GET(value="/clients/{client}/templates")
    public DTOTemplatesResponse getTemplates(@Path(value="client") long var1, @Query(value="operationType") String var3, @Query(value="serviceId") Integer var4) throws KeeperApiException, IOException;

    @DELETE(value="/clients/{client}/templates/{id}")
    public DTOResponse removeTemplate(@Path(value="client") long var1, @Path(value="id") long var3) throws KeeperApiException, IOException;

    @POST(value="/clients/{client}/templates")
    public DTOTemplateResponse createTemplate(@Path(value="client") long var1, @Body DTOTemplate var3) throws KeeperApiException, IOException;

    @PUT(value="/clients/{client}/templates/{id}")
    public DTOTemplateResponse editTemplate(@Path(value="client") long var1, @Path(value="id") long var3, @Body DTOTemplate var5) throws KeeperApiException, IOException;

    @GET(value="/clients/{client}/autopayments")
    public DTOAutoPaymentsResponse getAutoPayments(@Path(value="client") long var1) throws KeeperApiException, IOException;

    @DELETE(value="/clients/{client}/autopayments/{id}")
    public DTOResponse removeAutoPayment(@Path(value="client") long var1, @Path(value="id") long var3) throws KeeperApiException, IOException;

    @PUT(value="/clients/{client}/autopayments/{id}")
    public DTOAutoPaymentResponse editAutoPayment(@Path(value="client") long var1, @Path(value="id") long var3, @Body DTOAutoPayment var5) throws KeeperApiException, IOException;

    @POST(value="/clients/{client}/autopayments")
    public DTOAutoPaymentResponse createAutoPayment(@Path(value="client") long var1, @Body DTOAutoPayment var3) throws KeeperApiException, IOException;

    @GET(value="/clients/{client}/messages/income")
    public DTOMessagePagerResponse getIncomeMessages(@Path(value="client") long var1, @Query(value="page") int var3, @Query(value="pageSize") int var4) throws KeeperApiException, IOException;

    @GET(value="/clients/{client}/messages/outcome")
    public DTOMessagePagerResponse getOutcomeMessages(@Path(value="client") long var1, @Query(value="page") int var3, @Query(value="pageSize") int var4) throws KeeperApiException, IOException;

    @DELETE(value="/clients/{client}/messages/{id}")
    public DTOResponse deleteMessage(@Path(value="client") long var1, @Path(value="id") long var3) throws KeeperApiException, IOException;

    @POST(value="/clients/{client}/messages")
    public DTOResponse createMessage(@Path(value="client") long var1, @Body DTOInternalMessage var3) throws KeeperApiException, IOException;

    @GET(value="/clients/{client}/bill/outcome")
    public DTOBillPagerResponse getOutcomeBills(@Path(value="client") long var1, @Query(value="page") int var3, @Query(value="pageSize") int var4) throws KeeperApiException, IOException;

    @GET(value="/clients/{client}/bill/income")
    public DTOBillPagerResponse getIncomeBills(@Path(value="client") long var1, @Query(value="page") int var3, @Query(value="pageSize") int var4) throws KeeperApiException, IOException;

    @PUT(value="/clients/{client}/bill/{id}/accept")
    public DTOResponse payBill(@Path(value="client") long var1, @Path(value="id") long var3) throws KeeperApiException, IOException;

    @PUT(value="/clients/{client}/bill/{id}/cancel")
    public DTOResponse cancelBill(@Path(value="client") long var1, @Path(value="id") long var3) throws KeeperApiException, IOException;

    @POST(value="/clients/{client}/bill")
    public DTONewClientBillResponse createBill(@Path(value="client") long var1, @Body DTOClientBill var3) throws KeeperApiException, IOException;

    @PUT(value="/clients/{client}/options/change/password")
    public DTOChangePasswordResponse changePassword(@Path(value="client") long var1, @Body DTOChangePassword var3) throws KeeperApiException, IOException;

    @PUT(value="/clients/{client}/options/change/paypassword/secure")
    public DTOResponse changePayPassword(@Path(value="client") long var1, @Body DTOChangePayPasswordSecure var3) throws KeeperApiException, IOException;

    @PUT(value="/clients/{client}/options/private")
    public DTOPrivateResponse saveProfile(@Path(value="client") long var1, @Body DTOPrivate var3) throws KeeperApiException, IOException;

    @POST(value="/system/feedback")
    public DTOResponse sendFeedback(@Body DTOFeedback var1) throws KeeperApiException, IOException;

    @GET(value="/system/news")
    public DTONewsPagerResponse getNews(@Query(value="page") int var1, @Query(value="pageSize") int var2) throws KeeperApiException, IOException;

    @POST(value="/clients/{client}/payment/{id}/confirm")
    public DTOCheckResponse confirmOperation(@Path(value="client") long var1, @Path(value="id") long var3, @Body DTOConfirmOperation var5) throws KeeperApiException, IOException;

    @POST(value="/clients/{client}/pin/{id}")
    public DTOResponse confirmPinOperation(@Path(value="client") long var1, @Path(value="id") long var3, @Body DTOPinConfirm var5) throws KeeperApiException, IOException;

    @PUT(value="/clients/{client}/messages/{id}")
    public DTOResponse readMessage(@Path(value="client") long var1, @Path(value="id") long var3) throws KeeperApiException, IOException;

    @POST(value="/system/online/advanced")
    public DTOAdvancedResponse advancedHandlerRequest(@Body DTOAdvanced var1) throws KeeperApiException, IOException;

    @POST(value="/clients/{client}/payment/{id}/create/template")
    public DTOTemplateResponse createTemplateByOperation(@Path(value="client") long var1, @Path(value="id") long var3, @Body DTOBlankTemplate var5) throws KeeperApiException, IOException;

    @PUT(value="/clients/{client}/change/number")
    public DTOChangeNumberResponse changeNumber(@Path(value="client") long var1, @Body DTOChangeNumber var3) throws KeeperApiException, IOException;

    @GET(value="/system/point")
    public DTOPointsResponse getProcessingPoints(@Query(value="needcity") Boolean var1, @Query(value="fields") String var2, @Query(value="id_city") Short var3, @Query(value="id_processing_point") Integer var4) throws KeeperApiException, IOException;

    @GET(value="/system/point/paginator")
    public DTOPointPagerResponse getProcessingPointsPaginator(@Query(value="latitude") double var1, @Query(value="longitude") double var3, @Query(value="radius") int var5, @Query(value="page") int var6, @Query(value="pageSize") short var7) throws KeeperApiException, IOException;

    @POST(value="/clients/{client}/payment/{id}/create/autopayment")
    public DTOAutoPaymentResponse createAutoPaymentByOperation(@Path(value="client") long var1, @Path(value="id") long var3, @Body DTOBlankAutoPayment var5) throws KeeperApiException, IOException;

    @POST(value="/clients/{client}/templates/delete/list")
    public DTOResponse deleteTemplates(@Path(value="client") long var1, @Body DTOLongList var3) throws KeeperApiException, IOException;

    @POST(value="/clients/{client}/autopayments/delete/list")
    public DTOResponse deleteAutoPayments(@Path(value="client") long var1, @Body DTOLongList var3) throws KeeperApiException, IOException;

    @POST(value="/clients/{client}/close")
    public DTOCloseResponse closeWallet(@Path(value="client") long var1) throws KeeperApiException, IOException;

    @PUT(value="/clients/{client}/options/change/secret")
    public DTOResponse saveSecretWord(@Path(value="client") long var1, @Body DTOChangeSecretKey var3) throws KeeperApiException, IOException;

    @POST(value="/clients/{client}/messages/delete/list")
    public DTOResponse deleteMessages(@Path(value="client") long var1, @Body DTOLongList var3) throws KeeperApiException, IOException;

    @GET(value="/clients/{client}/options/limit/{clientAccount}")
    public DTOAccountLimitResponse getLimits(@Path(value="client") long var1, @Path(value="clientAccount") long var3) throws KeeperApiException, IOException;

    @PUT(value="/clients/{client}/options/limit/secure/{clientAccount}")
    public DTOResponse saveLimits(@Path(value="client") long var1, @Path(value="clientAccount") long var3, @Body DTOAccountLimitInfoSecure var5) throws KeeperApiException, IOException;

    @GET(value="/clients/{client}/notifications/count")
    public DTONotificationsInfoResponse getNotificationsCount(@Path(value="client") long var1) throws KeeperApiException, IOException;

    @POST(value="/clients/{client}/bill/accept/multiple")
    public DTOResponse acceptInvoices(@Path(value="client") long var1, @Body DTOLongList var3) throws KeeperApiException, IOException;

    @POST(value="/clients/{client}/bill/cancel/multiple")
    public DTOResponse cancelInvoices(@Path(value="client") long var1, @Body DTOLongList var3) throws KeeperApiException, IOException;

    @GET(value="/clients/{client}/payment/check/by/id/{id}")
    public DTOCheckResponse getCheckByOperationId(@Path(value="client") long var1, @Path(value="id") long var3) throws KeeperApiException, IOException;

    @POST(value="/clients/{client}/bill/all")
    public DTOBillPagerResponse getAllBills(@Path(value="client") long var1, @Body DTOBills var3) throws KeeperApiException, IOException;

    @POST(value="/system/client/event")
    public DTOResponse clientEvent(@Body DTOClientEvent var1) throws KeeperApiException, IOException;

    @POST(value="/clients/registration/full")
    public DTOLoginResponse registrationFull(@Body DTORegistration var1) throws KeeperApiException, IOException;

    @GET(value="/clients/anonymous")
    public DTOAnonymousResponse isAnonymousExists() throws KeeperApiException, IOException;

    @POST(value="/clients/login/secure")
    public DTOSecureLoginResponse secureLogin(@Body DTOLogin var1) throws KeeperApiException, IOException;

    @POST(value="/clients/login/pin/{id}")
    public DTOLoginResponse confirmLogin(@Path(value="id") long var1, @Body DTOLoginConfirm var3) throws KeeperApiException, IOException;

    @POST(value="/clients/registration/{id}/confirm")
    public DTOResponse confirmRegister(@Path(value="id") long var1, @Body DTOPinConfirm var3) throws KeeperApiException, IOException;

    @GET(value="/clients/{client}")
    public DTOInfoResponse getClientInfo(@Path(value="client") long var1, @Query(value="extended") boolean var3) throws KeeperApiException, IOException;

    @GET(value="/clients/{client}/options/email/change")
    public DTORequestEmailChangeResponse getEmailChangeRequest(@Path(value="client") long var1) throws KeeperApiException, IOException;

    @PUT(value="/clients/{client}/options/email/change")
    public DTOResponse createRequestEmailChange(@Path(value="client") long var1, @Body DTOEmailChange var3) throws KeeperApiException, IOException;

    @GET(value="/clients/exist/{login}")
    public DTOResponse isClientExists(@Path(value="login") String var1) throws KeeperApiException, IOException;

    @GET(value="/clients/registration/status/{login}")
    public DTORegistrationStatusResponse getRegistrationStatus(@Path(value="login") String var1) throws KeeperApiException, IOException;

    @GET(value="/clients/{client}/options/private")
    public DTOPrivateResponse getPrivate(@Path(value="client") long var1) throws KeeperApiException, IOException;

    @PUT(value="/clients/{client}/options/login/type/change")
    public DTOResponse changeLoginType(@Path(value="client") long var1, @Body DTOChangeLoginType var3) throws KeeperApiException, IOException;

    @GET(value="/clients/{client}/options/notify")
    public DTOSubscribeResponse getNotify(@Path(value="client") long var1) throws KeeperApiException, IOException;

    @PUT(value="/clients/{client}/options/notify")
    public DTOSaveSubscribeResponse saveSubscribes(@Path(value="client") long var1, @Body DTOSubscribeSave var3) throws KeeperApiException, IOException;

    @GET(value="/clients/{client}/cashsource")
    public DTOBalanceResponse balanceCBC(@Path(value="client") long var1, @Query(value="number") String var3) throws KeeperApiException, IOException;

    @POST(value="/clients/{client}/payment/{id}/confirm/without/check")
    public DTOCheckResponse confirmOperationWithoutCheck(@Path(value="client") long var1, @Path(value="id") long var3, @Body DTOConfirmOperation var5) throws KeeperApiException, IOException;

    @POST(value="/clients/{client}/autopayments/{id}/confirm")
    public DTOAutoPaymentResponse confirmAutoPayment(@Path(value="client") long var1, @Path(value="id") long var3, @Body DTOConfirmAutopayment var5) throws KeeperApiException, IOException;

    @POST(value="/autopayments/create/payment")
    public DTOResponse insertOperationFromAutopayment(@Query(value="client") long var1, @Query(value="autoPayment") long var3, @Query(value="isExecuteToday") boolean var5, @Body DTOPayment var6) throws KeeperApiException, IOException;

    @GET(value="/system/reference/formreference/{id}")
    public DTOFormReferenceResponse getFormById(@Path(value="id") int var1) throws KeeperApiException, IOException;

    @GET(value="/system/reference/scenario/{id}")
    public DTOScenarioReferenceResponse getScenarioById(@Path(value="id") int var1) throws KeeperApiException, IOException;

    @GET(value="/system/reference/formreference/{id}")
    public DTOFileReferenceNotParsedResponse getFormByIdNotParsed(@Path(value="id") int var1) throws KeeperApiException, IOException;

    @GET(value="/system/reference/scenario/{id}")
    public DTOFileReferenceNotParsedResponse getScenarioByIdNotParsed(@Path(value="id") int var1) throws KeeperApiException, IOException;

    @GET(value="/system/point/paginator")
    public DTOPointPagerResponse getPointsPaginator(@Query(value="latitude") double var1, @Query(value="longitude") double var3, @Query(value="radius") int var5, @Query(value="page") short var6, @Query(value="pageSize") short var7) throws KeeperApiException, IOException;

    @GET(value="/clients/{client}/subscriptions/{id}")
    public DTOSubscriptionInfoResponse getSubscriptionById(@Path(value="client") long var1, @Path(value="id") long var3) throws KeeperApiException, IOException;

    @POST(value="/clients/{client}/subscriptions")
    public DTOSubscriptionIdResponse createSubscription(@Path(value="client") long var1, @Body DTOSubscription var3) throws KeeperApiException, IOException;

    @GET(value="/clients/{client}/subscriptions/actual-bills")
    public DTOSubscriptionBillsResponse getActualSubscriptionBills(@Path(value="client") long var1, @Query(value="page") short var3, @Query(value="pageSize") short var4) throws KeeperApiException, IOException;

    @GET(value="/clients/{client}/subscriptions/archive-bills")
    public DTOSubscriptionBillsResponse getArchiveSubscriptionBills(@Path(value="client") long var1, @Query(value="page") short var3, @Query(value="pageSize") short var4) throws KeeperApiException, IOException;

    @GET(value="/clients/{client}/subscriptions/debatable-bills")
    public DTOSubscriptionBillsResponse getDebutableSubscriptionBills(@Path(value="client") long var1, @Query(value="page") short var3, @Query(value="pageSize") short var4) throws KeeperApiException, IOException;

    @GET(value="/clients/{client}/subscriptions/bills")
    public DTOSubsBillsAllResponse getAllSubscriptionBills(@Path(value="client") long var1) throws KeeperApiException, IOException;

    @POST(value="/clients/registration/extended")
    public DTORegistrationResponse extendedRegistration(@Body DTORegistrationExtended var1) throws KeeperApiException, IOException;

    @GET(value="/address/autocomplete/cities")
    public DTOAddressInfoResponse getCitiesAutoComplete(@Query(value="city_name") String var1) throws KeeperApiException, IOException;

    @GET(value="/address/autocomplete/streets")
    public DTOAddressInfoResponse getStreetsAutoComplete(@Query(value="city_id") int var1, @Query(value="street_name") String var2) throws KeeperApiException, IOException;

    @GET(value="/address/autocomplete/buildings")
    public DTOAddressInfoResponse getBuildingsAutoComplete(@Query(value="city_id") int var1, @Query(value="street_id") int var2, @Query(value="building_name") String var3) throws KeeperApiException, IOException;

    @GET(value="/address/autocomplete/rooms")
    public DTOAddressInfoResponse getRoomsAutoComplete(@Query(value="city_id") int var1, @Query(value="street_id") int var2, @Query(value="building_id") int var3, @Query(value="room_name") String var4) throws KeeperApiException, IOException;
}

