/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.db.model.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PhoneNumber {
    private String number;
    private String code;

    public PhoneNumber() {
    }

    PhoneNumber(String number, String code) {
        this.number = number;
        this.code = code;
    }

    public static boolean isValid(String fullNumber, String pattern) {
        if (fullNumber == null) {
            throw new IllegalArgumentException("PhoneNumber::isValid - \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 [fullNumber] \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        if (pattern == null || pattern.isEmpty()) {
            throw new IllegalArgumentException("PhoneNumber::isValid - \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 [pattern] \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c");
        }
        return fullNumber.matches(pattern);
    }

    public static PhoneNumber parse(String fullNumber, String pattern) {
        if (fullNumber == null) {
            throw new IllegalArgumentException("PhoneNumber::parse - \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 [fullNumber] \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        if (pattern == null || pattern.isEmpty()) {
            throw new IllegalArgumentException("PhoneNumber::parse - \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 [pattern] \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c");
        }
        Pattern pat = Pattern.compile(pattern);
        Matcher m = pat.matcher(fullNumber);
        if (m.find()) {
            String code = m.group();
            String number = m.replaceAll("");
            return new PhoneNumber(number, code);
        }
        throw new IllegalArgumentException("PhoneNumber::parse - \u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b. \u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u0438\u0432\u043a\u0438 \u043d\u043e\u043c\u0435\u0440\u0430");
    }

    public static PhoneNumber create(String number, String code) {
        if (number == null) {
            throw new IllegalArgumentException("PhoneNumber::create - \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 [number] \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        if (code == null) {
            throw new IllegalArgumentException("PhoneNumber::create - \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 [code] \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        return new PhoneNumber(number, code);
    }

    public static String clearMask(String phone) {
        if (phone == null || phone.isEmpty()) {
            return "";
        }
        return phone.replaceAll("\\(|\\)|-|\\s|\\+", "");
    }

    public String getNumber() {
        return this.number;
    }

    public String getCode() {
        return this.code;
    }

    public String getFullNumber() {
        return this.getCode() + this.getNumber();
    }

    public boolean isSame(String fullNumber) {
        return this.getFullNumber().equals(fullNumber);
    }

    public String toString() {
        return "PhoneNumber[number=" + this.number + ", code=" + this.code + ']';
    }
}

