/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.db.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;
import ru.softlogic.keeper.annotation.documentation.FieldDoc;
import ru.softlogic.keeper.annotation.documentation.TypeDoc;
import ru.softlogic.keeper.db.model.Report;
import ru.softlogic.keeper.db.model.ReportParamValue;
import ru.softlogic.keeper.db.model.ReportTransport;
import ru.softlogic.keeper.db.model.common.PrimaryKey;

@Entity
@Table(name="report_schedule")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
@TypeDoc(value="\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0442\u0447\u0435\u0442\u043e\u0432")
public class ReportSchedule
extends PrimaryKey {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="report_schedule_id_seq", sequenceName="report_schedule_id_seq", allocationSize=1)
    @GeneratedValue(generator="report_schedule_id_seq", strategy=GenerationType.SEQUENCE)
    private Integer id;
    @Basic(optional=false)
    @Column(name="name")
    @FieldDoc(value="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435")
    private String name;
    @JoinColumn(name="report", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @FieldDoc(value="\u041e\u0442\u0447\u0435\u0442", required={"id"})
    private Report report;
    @JoinColumn(name="report_transport", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @FieldDoc(value="\u041e\u0442\u0447\u0435\u0442", required={"id"})
    private ReportTransport reportTransport;
    @Basic(optional=false)
    @Column(name="targets")
    @FieldDoc(value="\u0410\u0434\u0440\u0435\u0441\u0430 \u0434\u043e\u0441\u0442\u0430\u0432\u043a\u0438 email")
    private String targets;
    @Basic(optional=false)
    @Column(name="cron")
    @FieldDoc(value="\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 cron, \u0432\u043e\u0442 \u043f\u0440\u0438\u043c\u0435\u0440 \"1 0 0 * * ?\"")
    private String cron;
    @Basic(optional=false)
    @Column(name="is_once", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    @FieldDoc(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0435\u0434\u0438\u043d\u043e\u0440\u0430\u0437\u043e\u0432\u043e\u0433\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f")
    private Boolean isOnce;
    @Basic(optional=false)
    @Column(name="is_deleted", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    @FieldDoc(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a, \u0447\u0442\u043e \u043e\u0442\u0447\u0435\u0442 \u0443\u0434\u0430\u043b\u0435\u043d")
    private Boolean isDeleted;
    @Basic(optional=false)
    @Column(name="last_schedule")
    @Temporal(value=TemporalType.TIMESTAMP)
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a\u043e\u043c")
    private Date lastSchedule;
    @Basic(optional=false)
    @Column(name="last_update")
    @Temporal(value=TemporalType.TIMESTAMP)
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f")
    private Date lastUpdate;
    @Basic(optional=false)
    @Column(name="last_execute")
    @Temporal(value=TemporalType.TIMESTAMP)
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f")
    private Date lastExecute;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="reportSchedule")
    @FieldDoc(value="\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", required={"id"})
    private List<ReportParamValue> reportParamValues;

    public ReportSchedule() {
        this.isOnce = Boolean.FALSE;
        this.isDeleted = Boolean.FALSE;
    }

    public ReportSchedule(Integer id) {
        this.id = id;
        this.isOnce = Boolean.FALSE;
        this.isDeleted = Boolean.FALSE;
    }

    public ReportSchedule(String name, Report report, ReportTransport reportTransport, String targets, String cron, Boolean isOnce) {
        this.name = name;
        this.report = report;
        this.reportTransport = reportTransport;
        this.targets = targets;
        this.cron = cron;
        this.isOnce = isOnce;
        this.isDeleted = Boolean.FALSE;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public ReportTransport getReportTransport() {
        return this.reportTransport;
    }

    public void setReportTransport(ReportTransport reportTransport) {
        this.reportTransport = reportTransport;
    }

    public String getTargets() {
        return this.targets;
    }

    public void setTargets(String targets) {
        this.targets = targets;
    }

    public String getCron() {
        return this.cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public List<ReportParamValue> getReportParamValues() {
        return this.reportParamValues;
    }

    public void setReportParamValues(List<ReportParamValue> reportParamValues) {
        this.reportParamValues = reportParamValues;
    }

    public String getReportJobName() {
        return this.getReport().getCode() + ':' + Integer.toString(this.getId());
    }

    public Boolean getIsOnce() {
        return this.isOnce;
    }

    public void setIsOnce(Boolean isOnce) {
        this.isOnce = isOnce;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public Date getLastSchedule() {
        return this.lastSchedule;
    }

    public void setLastSchedule(Date lastSchedule) {
        this.lastSchedule = lastSchedule;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public Date getLastExecute() {
        return this.lastExecute;
    }

    public void setLastExecute(Date lastExecute) {
        this.lastExecute = lastExecute;
    }

    public int hashCode() {
        return this._hashCode();
    }

    public boolean equals(Object object) {
        return this._equals(object, ReportSchedule.class);
    }

    public String toString() {
        return this._toString(ReportSchedule.class);
    }
}

