/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.db.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ru.softlogic.keeper.annotation.documentation.FieldDoc;
import ru.softlogic.keeper.db.model.CashSource;
import ru.softlogic.keeper.db.model.Client;
import ru.softlogic.keeper.db.model.ClientAccount;
import ru.softlogic.keeper.db.model.Currency;
import ru.softlogic.keeper.db.model.InterfaceType;
import ru.softlogic.keeper.db.model.MenuItem;
import ru.softlogic.keeper.db.model.MerchantRequest;
import ru.softlogic.keeper.db.model.OperationAttribute;
import ru.softlogic.keeper.db.model.OperationLayer;
import ru.softlogic.keeper.db.model.OperationSystemAttribute;
import ru.softlogic.keeper.db.model.OperationType;
import ru.softlogic.keeper.db.model.Processing;
import ru.softlogic.keeper.db.model.Service;
import ru.softlogic.keeper.db.model.SubOperation;
import ru.softlogic.keeper.db.model.common.PrimaryKey;

@Entity
@Table(name="operation")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
public class Operation
extends PrimaryKey {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="operation_id_seq", sequenceName="operation_id_seq", allocationSize=1)
    @GeneratedValue(generator="operation_id_seq", strategy=GenerationType.SEQUENCE)
    @FieldDoc(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440")
    private Long id;
    @Basic(optional=false)
    @Column(name="account")
    @FieldDoc(value="ID 1")
    private String account;
    @Column(name="account2")
    @FieldDoc(value="ID 2")
    private String account2;
    @Basic(optional=false)
    @Column(name="date_add")
    @Temporal(value=TemporalType.TIMESTAMP)
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f")
    private Date dateAdd;
    @Basic(optional=false)
    @Column(name="date_update")
    @Temporal(value=TemporalType.TIMESTAMP)
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f")
    private Date dateUpdate;
    @Column(name="date_writeoff")
    @Temporal(value=TemporalType.TIMESTAMP)
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0438\u043b\u0438 \u043e\u0442\u043c\u0435\u043d\u044b \u0440\u0435\u0437\u0435\u0440\u0432\u0430 \u043f\u043e \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0443 \u043e\u043f\u043b\u0430\u0442\u044b")
    private Date dateWriteoff;
    @Basic(optional=false)
    @Column(name="sum_in")
    @FieldDoc(value="\u0421\u0443\u043c\u043c\u0430 \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u0430\u044f(\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f)")
    private int sumIn;
    @Basic(optional=false)
    @Column(name="sum_comm")
    @FieldDoc(value="\u0421\u0443\u043c\u043c\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438")
    private int sumComm;
    @Basic(optional=false)
    @Column(name="sum_out")
    @FieldDoc(value="\u0421\u0443\u043c\u043c\u0430 \u0437\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f")
    private int sumOut;
    @Basic
    @Column(name="sum_comm_bank")
    @FieldDoc(value="\u0421\u0443\u043c\u043c\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438 \u0431\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b")
    private Integer sumCommBank;
    @Basic(optional=false)
    @Column(name="state")
    @FieldDoc(value="\u0421\u0442\u0430\u0442\u0443\u0441")
    private short state;
    @Basic(optional=false)
    @Column(name="sub_state")
    @FieldDoc(value="\u041f\u043e\u0434\u0441\u0442\u0430\u0442\u0443\u0441")
    private short subState;
    @Column(name="provider_trans")
    @FieldDoc(value="\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430")
    private String providerTrans;
    @Basic(optional=false)
    @Column(name="operation_number")
    @FieldDoc(value="\u041d\u043e\u043c\u0435\u0440 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438")
    private int operationNumber;
    @Basic(optional=false)
    @Column(name="device_uid")
    @FieldDoc(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430")
    private String deviceUid;
    @Column(name="check_number")
    @FieldDoc(value="\u041d\u043e\u043c\u0435\u0440 \u0447\u0435\u043a\u0430")
    private String checkNumber;
    @Column(name="commentary")
    @FieldDoc(value="\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439")
    private String comment;
    @Column(name="ip")
    @FieldDoc(value="IP \u0430\u0434\u0440\u0435\u0441")
    private String ip;
    @JoinColumn(name="service", referencedColumnName="id")
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @FieldDoc(value="\u0421\u0435\u0440\u0432\u0438\u0441", required={"id"})
    private Service service;
    @JoinColumn(name="operation_type", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @FieldDoc(value="\u0422\u0438\u043f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438", required={"id"})
    private OperationType operationType;
    @JoinColumn(name="operation_layer", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @FieldDoc(value="\u0421\u043b\u043e\u0439 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438", required={"id"})
    @JsonIgnore
    private OperationLayer operationLayer;
    @JoinColumn(name="interface_type_add", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @FieldDoc(value="\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438", required={"id"})
    private InterfaceType interfaceTypeAdd;
    @JoinColumn(name="currency", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @FieldDoc(value="\u0412\u0430\u043b\u044e\u0442\u0430", required={"id"})
    private Currency currency;
    @JoinColumn(name="client_account", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @FieldDoc(value="\u0421\u0447\u0435\u0442 \u043a\u043b\u0438\u0435\u043d\u0442\u0430", required={"id"})
    private ClientAccount clientAccount;
    @JoinColumn(name="client", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @FieldDoc(value="\u041a\u043b\u0438\u0435\u043d\u0442", required={"id"})
    private Client client;
    @JoinColumn(name="cash_source", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @FieldDoc(value="\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u043f\u043b\u0430\u0442\u0435\u0436\u0430", required={"id"})
    private CashSource cashSource;
    @JoinColumn(name="processing", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @FieldDoc(value="\u041f\u0440\u043e\u0446\u0435\u0441\u0441\u0438\u043d\u0433", required={"id"})
    @JsonIgnore
    private Processing processing;
    @JoinColumn(name="menu_item", referencedColumnName="id")
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @FieldDoc(value="\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u043c\u0435\u043d\u044e", required={"id"})
    private MenuItem menuItem;
    @Column(name="sum_prov")
    @FieldDoc(value="\u0421\u0443\u043c\u043c\u0430 \u0432 \u0432\u0430\u043b\u044e\u0442\u0435 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430")
    private Integer sumProv;
    @Column(name="sum_prov_currency")
    @FieldDoc(value="\u041a\u043e\u0434 \u0432\u0430\u043b\u044e\u0442\u044b \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430")
    private String sumProvCurrency;
    @Column(name="last_processing_error")
    @FieldDoc(value="\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0438\u043d\u0433\u0430")
    private Short lastProcessingError;
    @Transient
    @FieldDoc(value="\u0428\u0430\u0431\u043b\u043e\u043d\u044b \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f", required={"id"})
    private List<SubOperation> subOperations;
    @Transient
    @FieldDoc(value="\u0417\u0430\u043f\u0440\u043e\u0441 \u043c\u0435\u0440\u0447\u0430\u043d\u0442\u0430")
    private MerchantRequest merchantRequest;
    @Transient
    @FieldDoc(value="\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044b \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438(\u0438\u0437 \u0444\u043e\u0440\u043c\u044b/\u0441\u0446\u0435\u043d\u0430\u0440\u0438\u044f)")
    private List<OperationAttribute> operationAttributes;
    @Transient
    @FieldDoc(value="\u0421\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u044b \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438")
    private List<OperationSystemAttribute> operationSystemAttributes;

    public Operation() {
    }

    public Operation(Long id) {
        this.id = id;
    }

    public Operation(Long id, String account, Date dateAdd, Date dateUpdate, int sumIn, int sumComm, int sumOut, short state, short subState) {
        this.id = id;
        this.account = account;
        this.dateAdd = dateAdd;
        this.dateUpdate = dateUpdate;
        this.sumIn = sumIn;
        this.sumComm = sumComm;
        this.sumOut = sumOut;
        this.state = state;
        this.subState = subState;
    }

    @JsonIgnore
    private static Double getSumReal(Integer sum) {
        return sum != null ? (double)sum.intValue() / 100.0 : 0.0;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getAccount2() {
        return this.account2;
    }

    public void setAccount2(String account2) {
        this.account2 = account2;
    }

    public Date getDateAdd() {
        return this.dateAdd;
    }

    public void setDateAdd(Date dateAdd) {
        this.dateAdd = dateAdd;
    }

    public Date getDateUpdate() {
        return this.dateUpdate;
    }

    public void setDateUpdate(Date dateUpdate) {
        this.dateUpdate = dateUpdate;
    }

    public Date getDateWriteoff() {
        return this.dateWriteoff;
    }

    public void setDateWriteoff(Date dateWriteoff) {
        this.dateWriteoff = dateWriteoff;
    }

    public int getSumIn() {
        return this.sumIn;
    }

    public void setSumIn(int sumIn) {
        this.sumIn = sumIn;
    }

    public int getSumComm() {
        return this.sumComm;
    }

    public void setSumComm(int sumComm) {
        this.sumComm = sumComm;
    }

    public int getSumOut() {
        return this.sumOut;
    }

    public void setSumOut(int sumOut) {
        this.sumOut = sumOut;
    }

    @JsonIgnore
    public Double getSumInReal() {
        return Operation.getSumReal(this.getSumIn());
    }

    @JsonIgnore
    public Double getSumCommReal() {
        return Operation.getSumReal(this.getSumComm());
    }

    @JsonIgnore
    public Double getSumCommBankReal() {
        return Operation.getSumReal(this.getSumCommBank());
    }

    @JsonIgnore
    public Double getSumOutReal() {
        return Operation.getSumReal(this.getSumOut());
    }

    public short getState() {
        return this.state;
    }

    public void setState(short state) {
        this.state = state;
    }

    public short getSubState() {
        return this.subState;
    }

    public void setSubState(short subState) {
        this.subState = subState;
    }

    public String getProviderTrans() {
        return this.providerTrans;
    }

    public void setProviderTrans(String providerTrans) {
        this.providerTrans = providerTrans;
    }

    public String getCheckNumber() {
        return this.checkNumber;
    }

    public void setCheckNumber(String checkNumber) {
        this.checkNumber = checkNumber;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    public OperationLayer getOperationLayer() {
        return this.operationLayer;
    }

    public void setOperationLayer(OperationLayer operationLayer) {
        this.operationLayer = operationLayer;
    }

    public InterfaceType getInterfaceTypeAdd() {
        return this.interfaceTypeAdd;
    }

    public void setInterfaceTypeAdd(InterfaceType interfaceTypeAdd) {
        this.interfaceTypeAdd = interfaceTypeAdd;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public ClientAccount getClientAccount() {
        return this.clientAccount;
    }

    public void setClientAccount(ClientAccount clientAccount) {
        this.clientAccount = clientAccount;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public CashSource getCashSource() {
        return this.cashSource;
    }

    public void setCashSource(CashSource cashSource) {
        this.cashSource = cashSource;
    }

    public Processing getProcessing() {
        return this.processing;
    }

    public void setProcessing(Processing processing) {
        this.processing = processing;
    }

    public int getOperationNumber() {
        return this.operationNumber;
    }

    public void setOperationNumber(int operationNumber) {
        this.operationNumber = operationNumber;
    }

    public String getDeviceUid() {
        return this.deviceUid;
    }

    public void setDeviceUid(String deviceUid) {
        this.deviceUid = deviceUid;
    }

    public MenuItem getMenuItem() {
        return this.menuItem;
    }

    public void setMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
    }

    public Integer getSumCommBank() {
        return this.sumCommBank;
    }

    public void setSumCommBank(Integer sumCommBank) {
        this.sumCommBank = sumCommBank;
    }

    public Integer getSumProv() {
        return this.sumProv;
    }

    public void setSumProv(Integer sumProv) {
        this.sumProv = sumProv;
    }

    public String getSumProvCurrency() {
        return this.sumProvCurrency;
    }

    public void setSumProvCurrency(String sumProvCurrency) {
        this.sumProvCurrency = sumProvCurrency;
    }

    public Short getLastProcessingError() {
        return this.lastProcessingError;
    }

    public void setLastProcessingError(Short lastProcessingError) {
        this.lastProcessingError = lastProcessingError;
    }

    public List<SubOperation> getSubOperations() {
        return this.subOperations;
    }

    public void setSubOperations(List<SubOperation> subOperations) {
        this.subOperations = subOperations;
    }

    public MerchantRequest getMerchantRequest() {
        return this.merchantRequest;
    }

    public void setMerchantRequest(MerchantRequest merchantRequest) {
        this.merchantRequest = merchantRequest;
    }

    public List<OperationAttribute> getOperationAttributes() {
        if (this.operationAttributes == null) {
            this.operationAttributes = new LinkedList<OperationAttribute>();
        }
        return this.operationAttributes;
    }

    public void setOperationAttributes(List<OperationAttribute> operationAttributes) {
        this.operationAttributes = operationAttributes;
    }

    public List<OperationSystemAttribute> getOperationSystemAttributes() {
        if (this.operationSystemAttributes == null) {
            this.operationSystemAttributes = new LinkedList<OperationSystemAttribute>();
        }
        return this.operationSystemAttributes;
    }

    public void setOperationSystemAttributes(List<OperationSystemAttribute> operationSystemAttributes) {
        this.operationSystemAttributes = operationSystemAttributes;
    }

    public int hashCode() {
        return this._hashCode();
    }

    public boolean equals(Object object) {
        return this._equals(object, Operation.class);
    }

    public String toString() {
        return "Operation{id=" + this.id + ", account='" + this.account + '\'' + ", account2='" + this.account2 + '\'' + ", dateAdd=" + this.dateAdd + ", dateUpdate=" + this.dateUpdate + ", dateWriteoff=" + this.dateWriteoff + ", sumIn=" + this.sumIn + ", sumComm=" + this.sumComm + ", sumOut=" + this.sumOut + ", sumCommBank=" + this.sumCommBank + ", state=" + this.state + ", subState=" + this.subState + ", providerTrans='" + this.providerTrans + '\'' + ", operationNumber=" + this.operationNumber + ", deviceUid='" + this.deviceUid + '\'' + ", checkNumber='" + this.checkNumber + '\'' + ", comment='" + this.comment + '\'' + ", ip='" + this.ip + '\'' + ", service=" + this.service + ", operationType=" + this.operationType + ", operationLayer=" + this.operationLayer + ", interfaceTypeAdd=" + this.interfaceTypeAdd + ", currency=" + this.currency + ", clientAccount=" + this.clientAccount + ", client=" + this.client + ", cashSource=" + this.cashSource + ", processing=" + this.processing + ", menuItem=" + this.menuItem + ", sumProv=" + this.sumProv + ", sumProvCurrency='" + this.sumProvCurrency + '\'' + ", lastProcessingError=" + this.lastProcessingError + ", subOperations=" + this.subOperations + ", merchantRequest=" + this.merchantRequest + ", operationAttributes=" + this.operationAttributes + ", operationSystemAttributes=" + this.operationSystemAttributes + '}';
    }
}

