/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.db.model;

import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;
import ru.softlogic.keeper.annotation.documentation.FieldDoc;
import ru.softlogic.keeper.db.model.MerchantLegal;
import ru.softlogic.keeper.db.model.MerchantParamValue;
import ru.softlogic.keeper.db.model.common.PrimaryKey;

@Entity
@Table(name="merchant")
public class Merchant
extends PrimaryKey {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="merchant_id_seq", sequenceName="merchant_id_seq", allocationSize=1)
    @GeneratedValue(generator="merchant_id_seq", strategy=GenerationType.SEQUENCE)
    private Integer id;
    @Basic(optional=false)
    @Column(name="name")
    private String name;
    @Basic(optional=false)
    @Column(name="code")
    private String code;
    @Basic(optional=false)
    @Column(name="date_add", insertable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateAdd;
    @Basic(optional=false)
    @Column(name="blocked", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    private boolean blocked;
    @JoinColumn(name="id", referencedColumnName="id")
    @OneToOne(optional=true, fetch=FetchType.EAGER)
    @FieldDoc(value="\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044b \u044e\u0440.\u043b\u0438\u0446\u0430", required={"id"})
    private MerchantLegal merchantLegal;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="merchant")
    @FieldDoc(value="\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", required={"id"})
    private List<MerchantParamValue> merchantParamValue;

    public Merchant() {
    }

    public Merchant(Integer id) {
        this.id = id;
    }

    public Merchant(String name, String code, Date dateAdd, boolean blocked) {
        this.name = name;
        this.code = code;
        this.dateAdd = dateAdd;
        this.blocked = blocked;
    }

    public static long getSerialVersionUID() {
        return 1L;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Date getDateAdd() {
        return this.dateAdd;
    }

    public void setDateAdd(Date dateAdd) {
        this.dateAdd = dateAdd;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public MerchantLegal getMerchantLegal() {
        return this.merchantLegal;
    }

    public void setMerchantLegal(MerchantLegal merchantLegal) {
        this.merchantLegal = merchantLegal;
    }

    public List<MerchantParamValue> getMerchantParamValue() {
        return this.merchantParamValue;
    }

    public void setMerchantParamValue(List<MerchantParamValue> merchantParamValue) {
        this.merchantParamValue = merchantParamValue;
    }

    public int hashCode() {
        return this._hashCode();
    }

    public boolean equals(Object object) {
        return this._equals(object, Merchant.class);
    }

    public String toString() {
        return this._toString(Merchant.class);
    }
}

