/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.db.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import ru.softlogic.keeper.db.model.ClientLocale;
import ru.softlogic.keeper.db.model.FileReference;
import ru.softlogic.keeper.db.model.FileReferenceType;
import ru.softlogic.keeper.db.model.InterfaceType;
import ru.softlogic.keeper.db.model.common.PrimaryKey;

@Entity
@Table(name="file_reference_sub_part")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
public class FileReferenceSubPart
extends PrimaryKey {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="file_reference_sub_part_id_seq", sequenceName="file_reference_sub_part_id_seq", allocationSize=1)
    @GeneratedValue(generator="file_reference_sub_part_id_seq", strategy=GenerationType.SEQUENCE)
    private Integer id;
    @Column(name="content")
    @Basic(fetch=FetchType.LAZY)
    private String content;
    @Column(name="code")
    private String code;
    @Basic(optional=false)
    @Column(name="crc32")
    private long crc32;
    @JoinColumn(name="file_reference", referencedColumnName="id")
    @ManyToOne(fetch=FetchType.LAZY)
    private FileReference fileReference;
    @JoinColumn(name="file_reference_type", referencedColumnName="id")
    @ManyToOne(fetch=FetchType.LAZY)
    private FileReferenceType fileReferenceType;
    @JoinColumn(name="client_locale", referencedColumnName="id")
    @ManyToOne(fetch=FetchType.LAZY)
    private ClientLocale clientLocale;
    @JoinColumn(name="interface_type", referencedColumnName="id")
    @ManyToOne(fetch=FetchType.LAZY)
    private InterfaceType interfaceType;
    @Basic(optional=false)
    @Column(name="generation")
    private short generation;

    public FileReferenceSubPart() {
    }

    public FileReferenceSubPart(String code, String content, long crc32, FileReference fileReference) {
        this.code = code;
        this.content = content;
        this.crc32 = crc32;
        this.fileReference = fileReference;
    }

    public ClientLocale getClientLocale() {
        return this.clientLocale;
    }

    public void setClientLocale(ClientLocale clientLocale) {
        this.clientLocale = clientLocale;
    }

    public FileReferenceType getFileReferenceType() {
        return this.fileReferenceType;
    }

    public void setFileReferenceType(FileReferenceType fileReferenceType) {
        this.fileReferenceType = fileReferenceType;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public int hashCode() {
        return this._hashCode();
    }

    public boolean equals(Object object) {
        return this._equals(object, FileReferenceSubPart.class);
    }

    public String toString() {
        return this._toString(FileReferenceSubPart.class);
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public long getCrc32() {
        return this.crc32;
    }

    public void setCrc32(long crc32) {
        this.crc32 = crc32;
    }

    public FileReference getFileReference() {
        return this.fileReference;
    }

    public void setFileReference(FileReference fileReference) {
        this.fileReference = fileReference;
    }

    public InterfaceType getInterfaceType() {
        return this.interfaceType;
    }

    public void setInterfaceType(InterfaceType interfaceType) {
        this.interfaceType = interfaceType;
    }

    public short getGeneration() {
        return this.generation;
    }

    public void setGeneration(short generation) {
        this.generation = generation;
    }
}

