/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.db.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import ru.softlogic.keeper.annotation.documentation.FieldDoc;
import ru.softlogic.keeper.db.model.Area;
import ru.softlogic.keeper.db.model.ClientLocale;
import ru.softlogic.keeper.db.model.FileReferenceMime;
import ru.softlogic.keeper.db.model.FileReferenceType;
import ru.softlogic.keeper.db.model.InterfaceType;
import ru.softlogic.keeper.db.model.common.Deletable;
import ru.softlogic.keeper.db.model.common.PrimaryKey;

@Entity
@Table(name="file_reference")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
public class FileReference
extends PrimaryKey
implements Deletable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="file_reference_id_seq", sequenceName="file_reference_id_seq", allocationSize=1)
    @GeneratedValue(generator="file_reference_id_seq", strategy=GenerationType.SEQUENCE)
    private Integer id;
    @Basic(optional=false)
    @Column(name="file_name")
    private String fileName;
    @Column(name="content")
    @Basic(fetch=FetchType.LAZY)
    private String content;
    @Basic(optional=false)
    @Column(name="crc32")
    private Long crc32;
    @JoinColumn(name="interface_type", referencedColumnName="id")
    @ManyToOne(fetch=FetchType.LAZY)
    private InterfaceType interfaceType;
    @JoinColumn(name="file_reference_type", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private FileReferenceType fileReferenceType;
    @JoinColumn(name="file_reference_mime", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private FileReferenceMime fileReferenceMime;
    @JoinColumn(name="area", referencedColumnName="id")
    @ManyToOne(fetch=FetchType.LAZY)
    private Area area;
    @Basic
    @Column(name="commentary")
    private String comment;
    @FieldDoc(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0441\u0442\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430")
    @Transient
    private boolean deleted;
    @JoinColumn(name="client_locale", referencedColumnName="id")
    @ManyToOne(fetch=FetchType.LAZY)
    private ClientLocale clientLocale;

    public FileReference() {
    }

    public FileReference(Integer id) {
        this.id = id;
    }

    public FileReference(Integer id, String fileName, Long crc32) {
        this.id = id;
        this.fileName = fileName;
        this.crc32 = crc32;
    }

    public ClientLocale getClientLocale() {
        return this.clientLocale;
    }

    public void setClientLocale(ClientLocale clientLocale) {
        this.clientLocale = clientLocale;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Long getCrc32() {
        return this.crc32;
    }

    public void setCrc32(Long crc32) {
        this.crc32 = crc32;
    }

    public InterfaceType getInterfaceType() {
        return this.interfaceType;
    }

    public void setInterfaceType(InterfaceType interfaceType) {
        this.interfaceType = interfaceType;
    }

    public FileReferenceType getFileReferenceType() {
        return this.fileReferenceType;
    }

    public void setFileReferenceType(FileReferenceType fileReferenceType) {
        this.fileReferenceType = fileReferenceType;
    }

    public FileReferenceMime getFileReferenceMime() {
        return this.fileReferenceMime;
    }

    public void setFileReferenceMime(FileReferenceMime fileReferenceMime) {
        this.fileReferenceMime = fileReferenceMime;
    }

    public Area getArea() {
        return this.area;
    }

    public void setArea(Area area) {
        this.area = area;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public int hashCode() {
        return this._hashCode();
    }

    public boolean equals(Object object) {
        return this._equals(object, FileReference.class);
    }

    public String toString() {
        return this._toString(FileReference.class);
    }
}

