/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.db.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Type;
import ru.softlogic.keeper.annotation.documentation.FieldDoc;
import ru.softlogic.keeper.annotation.documentation.TypeDoc;
import ru.softlogic.keeper.db.model.AuthType;
import ru.softlogic.keeper.db.model.ClientLocale;
import ru.softlogic.keeper.db.model.CustomizableContentStyle;
import ru.softlogic.keeper.db.model.CustomizableContentType;
import ru.softlogic.keeper.db.model.common.Deletable;
import ru.softlogic.keeper.db.model.common.PrimaryKey;

@Entity
@Table(name="customizable_content")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
@TypeDoc(value="\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u044b\u0439 (\u043d\u0430\u0441\u0442\u0440\u0430\u0438\u0432\u0430\u0435\u043c\u044b\u0439) \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435")
public class CustomizableContent
extends PrimaryKey
implements Deletable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="customizable_content_id_seq", sequenceName="customizable_content_id_seq", allocationSize=1)
    @GeneratedValue(generator="customizable_content_id_seq", strategy=GenerationType.SEQUENCE)
    private Integer id;
    @Basic(optional=false)
    @Column(name="code")
    private String code;
    @Basic(optional=false)
    @Column(name="name")
    private String name;
    @Basic(optional=false)
    @Column(name="enabled", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    @FieldDoc(value="\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0441\u0442\u044c")
    private Boolean enabled;
    @Column(name="default_content")
    @FieldDoc(value="\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e", help="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u0442\u0441\u044f \u0438 \u0434\u043b\u044f \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f, \u0438 \u0434\u043b\u044f \u0430\u043d\u043e\u043d\u0438\u043c\u043d\u043e\u0433\u043e")
    private String defaultContent;
    @Column(name="login_content")
    @FieldDoc(value="\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u043e\u0435, \u0435\u0441\u043b\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u043e\u0432\u0430\u043d", help="\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u0435\u0441\u043b\u0438 defaultContent \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043d\u043e")
    private String loginContent;
    @Column(name="logout_content")
    @FieldDoc(value="\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u043e\u0435, \u0435\u0441\u043b\u0438 \u0430\u043d\u043e\u043d\u0438\u043c\u043d\u044b\u0439 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", help="\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u0435\u0441\u043b\u0438 defaultContent \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043d\u043e")
    private String logoutContent;
    @Basic(optional=false)
    @Column(name="default_crc32")
    @JsonIgnore
    @FieldDoc(value="CRC32 \u043f\u043e defaultContent")
    private Long defaultCrc32 = 0L;
    @Basic(optional=false)
    @Column(name="login_crc32")
    @JsonIgnore
    @FieldDoc(value="CRC32 \u043f\u043e loginContent")
    private Long loginCrc32 = 0L;
    @Basic(optional=false)
    @Column(name="logout_crc32")
    @JsonIgnore
    @FieldDoc(value="CRC32 \u043f\u043e logoutContent")
    private Long logoutCrc32 = 0L;
    @FieldDoc(value="\u0420\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043a\u043e\u043d\u0442\u0435\u043d\u0442", required={"id"})
    @JoinColumn(name="pid", referencedColumnName="id")
    @ManyToOne(fetch=FetchType.LAZY)
    @NotFound(action=NotFoundAction.IGNORE)
    private CustomizableContent pid;
    @FieldDoc(value="\u041a\u0440\u0430\u0442\u043a\u0438\u0439 \u043a\u043e\u0434")
    @Basic(optional=false)
    @Column(name="short_code")
    private String shortCode;
    @FieldDoc(value="\u0421\u0442\u0438\u043b\u044c", required={"id"})
    @JoinColumn(name="customizable_content_style", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private CustomizableContentStyle customizableContentStyle;
    @FieldDoc(value="\u0422\u0438\u043f", required={"id"})
    @JoinColumn(name="customizable_content_type", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private CustomizableContentType customizableContentType;
    @FieldDoc(value="\u0422\u0438\u043f", required={"id"})
    @JoinColumn(name="auth_type", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private AuthType authType;
    @FieldDoc(value="\u042f\u0437\u044b\u043a")
    @JoinColumn(name="client_locale", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private ClientLocale clientLocale;
    @FieldDoc(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0441\u0442\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430")
    @Transient
    private boolean deleted;
    @Basic(optional=false)
    @Column(name="default_md5")
    @JsonIgnore
    @FieldDoc(value="MD5 \u043f\u043e defaultContent")
    private String defaultMd5;
    @Basic(optional=false)
    @Column(name="commentary")
    @JsonIgnore
    @FieldDoc(value="\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435")
    private String comment;
    @Basic(optional=false)
    @Column(name="default_client_locale", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    @FieldDoc(value="\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e")
    private Boolean defaultClientLocale = Boolean.FALSE;
    @Basic(optional=false)
    @Column(name="tmpl", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    @FieldDoc(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0448\u0430\u0431\u043b\u043e\u043d\u0430")
    private boolean template;
    @Transient
    @JsonIgnore
    private List<CustomizableContent> fields;

    public CustomizableContent() {
    }

    public CustomizableContent(Integer id) {
        this.id = id;
    }

    public CustomizableContent(Integer id, String code, String name, Boolean enabled) {
        this.id = id;
        this.code = code;
        this.name = name;
        this.enabled = enabled;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getDefaultContent() {
        return this.defaultContent;
    }

    public void setDefaultContent(String defaultContent) {
        this.defaultContent = defaultContent;
    }

    public String getLoginContent() {
        return this.loginContent;
    }

    public void setLoginContent(String loginContent) {
        this.loginContent = loginContent;
    }

    public String getLogoutContent() {
        return this.logoutContent;
    }

    public void setLogoutContent(String logoutContent) {
        this.logoutContent = logoutContent;
    }

    public Long getDefaultCrc32() {
        return this.defaultCrc32;
    }

    public void setDefaultCrc32(Long defaultCrc32) {
        this.defaultCrc32 = defaultCrc32;
    }

    public Long getLoginCrc32() {
        return this.loginCrc32;
    }

    public void setLoginCrc32(Long loginCrc32) {
        this.loginCrc32 = loginCrc32;
    }

    public Long getLogoutCrc32() {
        return this.logoutCrc32;
    }

    public void setLogoutCrc32(Long logoutCrc32) {
        this.logoutCrc32 = logoutCrc32;
    }

    public CustomizableContent getPid() {
        return this.pid;
    }

    public void setPid(CustomizableContent pid) {
        this.pid = pid;
    }

    public String getShortCode() {
        return this.shortCode;
    }

    public void setShortCode(String shortCode) {
        this.shortCode = shortCode;
    }

    public CustomizableContentStyle getCustomizableContentStyle() {
        return this.customizableContentStyle;
    }

    public void setCustomizableContentStyle(CustomizableContentStyle customizableContentStyle) {
        this.customizableContentStyle = customizableContentStyle;
    }

    public CustomizableContentType getCustomizableContentType() {
        return this.customizableContentType;
    }

    public void setCustomizableContentType(CustomizableContentType customizableContentType) {
        this.customizableContentType = customizableContentType;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public void setAuthType(AuthType authType) {
        this.authType = authType;
    }

    public ClientLocale getClientLocale() {
        return this.clientLocale;
    }

    public void setClientLocale(ClientLocale clientLocale) {
        this.clientLocale = clientLocale;
    }

    public String getDefaultMd5() {
        return this.defaultMd5;
    }

    public void setDefaultMd5(String defaultMd5) {
        this.defaultMd5 = defaultMd5;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Boolean getDefaultClientLocale() {
        return this.defaultClientLocale;
    }

    public void setDefaultClientLocale(Boolean defaultClientLocale) {
        this.defaultClientLocale = defaultClientLocale;
    }

    public boolean isTemplate() {
        return this.template;
    }

    public void setTemplate(boolean template) {
        this.template = template;
    }

    public List<CustomizableContent> getFields() {
        return this.fields;
    }

    public void setFields(List<CustomizableContent> fields) {
        this.fields = fields;
    }

    public int hashCode() {
        return this._hashCode();
    }

    public boolean equals(Object object) {
        return this._equals(object, CustomizableContent.class);
    }

    public String toString() {
        return "CustomizableContent{id=" + this.id + ", code='" + this.code + '\'' + ", name='" + this.name + '\'' + ", enabled=" + this.enabled + ", defaultContent='" + this.defaultContent + '\'' + ", loginContent='" + this.loginContent + '\'' + ", logoutContent='" + this.logoutContent + '\'' + ", defaultCrc32=" + this.defaultCrc32 + ", loginCrc32=" + this.loginCrc32 + ", logoutCrc32=" + this.logoutCrc32 + ", shortCode='" + this.shortCode + '\'' + ", customizableContentStyle=" + this.customizableContentStyle + ", customizableContentType=" + this.customizableContentType + ", authType=" + this.authType + ", clientLocale=" + this.clientLocale + ", deleted=" + this.deleted + ", defaultMd5='" + this.defaultMd5 + '\'' + ", comment='" + this.comment + '\'' + ", defaultClientLocale=" + this.defaultClientLocale + ", template=" + this.template + '}';
    }
}

