/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.db.model;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;
import ru.softlogic.keeper.annotation.documentation.FieldDoc;
import ru.softlogic.keeper.db.model.Area;
import ru.softlogic.keeper.db.model.InterfaceType;
import ru.softlogic.keeper.db.model.Person;
import ru.softlogic.keeper.db.model.common.PhoneNumber;
import ru.softlogic.keeper.db.model.common.PrimaryKey;

@Entity
@Table(name="client_registration_request")
public class ClientRegistrationRequest
extends PrimaryKey {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="client_reg_request_id_seq", sequenceName="client_reg_request_id_seq", allocationSize=1)
    @GeneratedValue(generator="client_reg_request_id_seq", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Basic(optional=false)
    @Column(name="login")
    private String login;
    @Basic(optional=false)
    @Column(name="login_number")
    private String loginNumber;
    @Basic(optional=false)
    @Column(name="login_code")
    private String loginCode;
    @Basic(optional=false)
    @Column(name="date_add")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateAdd;
    @Column(name="date_accept")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateAccept;
    @Basic(optional=false)
    @Column(name="password_hash")
    private String passwordHash;
    @Basic(optional=false)
    @Column(name="salt")
    private String salt;
    @Basic(optional=false)
    @Column(name="accept_oferta", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    private boolean acceptOferta;
    @JoinColumn(name="interface_type_add", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private InterfaceType interfaceTypeAdd;
    @JoinColumn(name="area", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Area area;
    @Column(name="ip")
    private String ip;
    @Basic(optional=true)
    @Column(name="external_identifier")
    private String externalIdentifier;
    @Basic(optional=false)
    @Column(name="incorrect_recovery_count")
    @FieldDoc(value="\u0427\u0438\u0441\u043b\u043e \u043f\u043e\u043f\u044b\u0442\u043e\u043a \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u043e\u043b\u044f")
    private short incorrectRecoveryCount;
    @Basic(optional=false)
    @Column(name="date_recovery")
    @Temporal(value=TemporalType.TIMESTAMP)
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u043f\u0435\u0440\u0432\u043e\u0439 \u043f\u043e\u043f\u044b\u0442\u043a\u0438 \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0437\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u0441\u0443\u0442\u043a\u0438")
    private Date dateRecovery;
    @Basic(optional=false)
    @Column(name="status")
    @FieldDoc(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u0437\u0430\u044f\u0432\u043a\u0438")
    private short status;
    @Basic(optional=false)
    @Column(name="u_code")
    @FieldDoc(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043a\u043e\u0434 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f")
    private String uCode;
    @JoinColumn(name="person", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Person person;
    @Basic(optional=true)
    @Column(name="referer")
    @FieldDoc(value="\u041e\u0442\u043a\u0443\u0434\u0430 \u043f\u0440\u0438\u0448\u0451\u043b \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c")
    private String referer;
    @Column(name="city")
    @FieldDoc(value="\u0413\u043e\u0440\u043e\u0434")
    private String city;
    @Column(name="street")
    @FieldDoc(value="\u0423\u043b\u0438\u0446\u0430")
    private String street;
    @Column(name="building")
    @FieldDoc(value="\u0414\u043e\u043c")
    private String building;
    @Column(name="room")
    @FieldDoc(value="\u041a\u0432\u0430\u0440\u0442\u0438\u0440\u0430")
    private String room;
    @Column(name="first_name")
    @FieldDoc(value="\u0418\u043c\u044f")
    private String firstName;
    @Column(name="middle_name")
    @FieldDoc(value="\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e")
    private String middleName;
    @Column(name="last_name")
    @FieldDoc(value="\u0424\u0430\u043c\u0438\u043b\u0438\u044f")
    private String lastName;
    @Column(name="email")
    @FieldDoc(value="\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441")
    private String email;

    public ClientRegistrationRequest() {
    }

    public ClientRegistrationRequest(Long id) {
        this.id = id;
    }

    public String getuCode() {
        return this.uCode;
    }

    public void setuCode(String uCode) {
        this.uCode = uCode;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getBuilding() {
        return this.building;
    }

    public void setBuilding(String building) {
        this.building = building;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public short getIncorrectRecoveryCount() {
        return this.incorrectRecoveryCount;
    }

    public void setIncorrectRecoveryCount(short incorrectRecoveryCount) {
        this.incorrectRecoveryCount = incorrectRecoveryCount;
    }

    public Date getDateRecovery() {
        return this.dateRecovery;
    }

    public void setDateRecovery(Date dateRecovery) {
        this.dateRecovery = dateRecovery;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public PhoneNumber getLoginObject() {
        return PhoneNumber.create(this.getLoginNumber(), this.getLoginCode());
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getLoginNumber() {
        return this.loginNumber;
    }

    public void setLoginNumber(String loginNumber) {
        this.loginNumber = loginNumber;
    }

    public String getLoginCode() {
        return this.loginCode;
    }

    public void setLoginCode(String loginCode) {
        this.loginCode = loginCode;
    }

    public Date getDateAdd() {
        return this.dateAdd;
    }

    public void setDateAdd(Date dateAdd) {
        this.dateAdd = dateAdd;
    }

    public Date getDateAccept() {
        return this.dateAccept;
    }

    public void setDateAccept(Date dateAccept) {
        this.dateAccept = dateAccept;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public void setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public InterfaceType getInterfaceTypeAdd() {
        return this.interfaceTypeAdd;
    }

    public void setInterfaceTypeAdd(InterfaceType interfaceTypeAdd) {
        this.interfaceTypeAdd = interfaceTypeAdd;
    }

    public Area getArea() {
        return this.area;
    }

    public void setArea(Area area) {
        this.area = area;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public boolean isAcceptOferta() {
        return this.acceptOferta;
    }

    public void setAcceptOferta(boolean acceptOferta) {
        this.acceptOferta = acceptOferta;
    }

    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    public void setExternalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public short getStatus() {
        return this.status;
    }

    public void setStatus(short status) {
        this.status = status;
    }

    public String getUCode() {
        return this.uCode;
    }

    public void setUCode(String uCode) {
        this.uCode = uCode;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public int hashCode() {
        return this._hashCode();
    }

    public boolean equals(Object object) {
        return this._equals(object, ClientRegistrationRequest.class);
    }

    public String toString() {
        return this._toString(ClientRegistrationRequest.class);
    }

    public String getReferer() {
        return this.referer;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }
}

