/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.db.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Type;
import ru.softlogic.keeper.annotation.documentation.FieldDoc;
import ru.softlogic.keeper.annotation.documentation.TypeDoc;
import ru.softlogic.keeper.db.model.BankSystem;
import ru.softlogic.keeper.db.model.ProcessingPaymentSource;
import ru.softlogic.keeper.db.model.common.DefaultUsable;
import ru.softlogic.keeper.db.model.common.Deletable;
import ru.softlogic.keeper.db.model.common.PrimaryKey;

@Entity
@Table(name="cash_source")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
@TypeDoc(value="\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u043f\u043b\u0430\u0442\u0435\u0436\u0430 (\u041f\u041c\u041a, \u0411\u0430\u043d\u043a \u043a\u0430\u0440\u0442\u0430, ...)")
public class CashSource
extends PrimaryKey
implements DefaultUsable,
Deletable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="id")
    @FieldDoc(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440")
    private Short id;
    @Basic(optional=false)
    @Column(name="code")
    @FieldDoc(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043a\u043e\u0434")
    private String code;
    @Basic(optional=false)
    @Column(name="name")
    @FieldDoc(value="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435")
    private String name;
    @Basic(optional=false)
    @Column(name="blocked", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    @FieldDoc(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0441\u0442\u0438")
    private Boolean blocked;
    @Basic(optional=false)
    @Column(name="use_default", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    @FieldDoc(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u043e\u0441\u0442\u0438 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e")
    private Boolean useDefault;
    @Basic(optional=false)
    @Column(name="use_online_verify", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    @JsonIgnore
    @FieldDoc(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u043e\u043d\u043b\u0430\u0439\u043d \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438")
    private Boolean useOnlineVerify;
    @Basic(optional=false)
    @Column(name="internal_cash", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    @JsonIgnore
    @FieldDoc(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0439 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438 (\u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043a\u043e\u0448\u0435\u043b\u044c\u043a\u0430)")
    private Boolean internalCash;
    @Column(name="min_sum")
    @FieldDoc(value="\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430")
    private Integer minSum;
    @Column(name="max_sum")
    @FieldDoc(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430")
    private Integer maxSum;
    @JoinColumn(name="bank_system", referencedColumnName="id")
    @JsonIgnore
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    private BankSystem bankSystem;
    @JoinColumn(name="override_cash_source", referencedColumnName="id")
    @JsonIgnore
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    private CashSource overrideCashSource;
    @Basic(optional=false)
    @Column(name="change_owner", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    @JsonIgnore
    @FieldDoc(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043e\u043f\u043b\u0430\u0442\u044b")
    private Boolean changeOwner;
    @Basic(optional=false)
    @Column(name="api_class")
    @JsonIgnore
    private String apiClass;
    @Basic(optional=false)
    @Column(name="accessible_for_autopayments", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    @FieldDoc(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0441\u0442\u0438 \u0434\u043b\u044f \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439")
    private Boolean accessibleForAutopayments;
    @JoinColumn(name="processing_payment_source", referencedColumnName="id")
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    private ProcessingPaymentSource processingPaymentSource;
    @Transient
    private boolean deleted;

    public CashSource() {
    }

    public CashSource(Short id) {
        this.id = id;
    }

    public CashSource(Short id, String code, String name, Boolean blocked, Boolean useDefault, Boolean internalCash, Boolean useOnlineVerify) {
        this.id = id;
        this.code = code;
        this.name = name;
        this.blocked = blocked;
        this.useDefault = useDefault;
        this.internalCash = internalCash;
        this.useOnlineVerify = useOnlineVerify;
    }

    @Override
    public Short getId() {
        return this.id;
    }

    public void setId(Short id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getBlocked() {
        return this.blocked;
    }

    public void setBlocked(Boolean blocked) {
        this.blocked = blocked;
    }

    @Override
    public Boolean getUseDefault() {
        return this.useDefault;
    }

    @Override
    public void setUseDefault(Boolean useDefault) {
        this.useDefault = useDefault;
    }

    public Boolean getInternalCash() {
        return this.internalCash;
    }

    public void setInternalCash(Boolean internalCash) {
        this.internalCash = internalCash;
    }

    public Boolean getUseOnlineVerify() {
        return this.useOnlineVerify;
    }

    public void setUseOnlineVerify(Boolean useOnlineVerify) {
        this.useOnlineVerify = useOnlineVerify;
    }

    public Integer getMinSum() {
        return this.minSum;
    }

    public void setMinSum(Integer minSum) {
        this.minSum = minSum;
    }

    public Integer getMaxSum() {
        return this.maxSum;
    }

    public void setMaxSum(Integer maxSum) {
        this.maxSum = maxSum;
    }

    public BankSystem getBankSystem() {
        return this.bankSystem;
    }

    public void setBankSystem(BankSystem bankSystem) {
        this.bankSystem = bankSystem;
    }

    public CashSource getOverrideCashSource() {
        return this.overrideCashSource;
    }

    public void setOverrideCashSource(CashSource overrideCashSource) {
        this.overrideCashSource = overrideCashSource;
    }

    public Boolean getChangeOwner() {
        return this.changeOwner;
    }

    public void setChangeOwner(Boolean changeOwner) {
        this.changeOwner = changeOwner;
    }

    public String getApiClass() {
        return this.apiClass;
    }

    public void setApiClass(String apiClass) {
        this.apiClass = apiClass;
    }

    public Boolean getAccessibleForAutopayments() {
        return this.accessibleForAutopayments;
    }

    public void setAccessibleForAutopayments(Boolean accessibleForAutopayments) {
        this.accessibleForAutopayments = accessibleForAutopayments;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public int hashCode() {
        return this._hashCode();
    }

    public boolean equals(Object object) {
        return this._equals(object, CashSource.class);
    }

    public ProcessingPaymentSource getProcessingPaymentSource() {
        return this.processingPaymentSource;
    }

    public void setProcessingPaymentSource(ProcessingPaymentSource processingPaymentSource) {
        this.processingPaymentSource = processingPaymentSource;
    }

    public String toString() {
        return "CashSource{id=" + this.id + ", code='" + this.code + '\'' + ", name='" + this.name + '\'' + ", blocked=" + this.blocked + ", useDefault=" + this.useDefault + ", useOnlineVerify=" + this.useOnlineVerify + ", internalCash=" + this.internalCash + ", minSum=" + this.minSum + ", maxSum=" + this.maxSum + ", bankSystem=" + this.bankSystem + ", overrideCashSource=" + this.overrideCashSource + ", changeOwner=" + this.changeOwner + ", apiClass='" + this.apiClass + '\'' + ", accessibleForAutopayments=" + this.accessibleForAutopayments + ", processingPaymentSource=" + this.processingPaymentSource + ", deleted=" + this.deleted + '}';
    }
}

