/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.db.model;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;
import ru.softlogic.keeper.db.model.common.PrimaryKey;

@Entity
@Table(name="access_role")
public class AccessRole
extends PrimaryKey {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="access_role_id_seq", sequenceName="access_role_id_seq", allocationSize=1)
    @GeneratedValue(generator="access_role_id_seq", strategy=GenerationType.SEQUENCE)
    private Integer id;
    @Basic(optional=false)
    @Column(name="code")
    private String code;
    @Basic(optional=false)
    @Column(name="name")
    private String name;
    @Basic(optional=false)
    @Column(name="send_sms_pin_for_auth", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    private Boolean sendSmsPinForAuth;
    @Column(name="min_length_password")
    private Integer minLengthPassword;
    @Column(name="alphabet")
    private Short alphabet;
    @Basic(optional=false)
    @Column(name="inactivity_period")
    private Integer inactivityPeriod;
    @Basic(optional=false)
    @Column(name="max_failed_login_count")
    private Integer maxFailedLoginCount;
    @Basic(optional=false)
    @Column(name="failed_login_interval")
    private Integer failedLoginInterval;
    @Basic(optional=false)
    @Column(name="pwd_change_freq")
    private Integer passwordChangeFreq;
    @Basic(optional=false)
    @Column(name="pwd_depth")
    private Integer passwordDepth;

    public AccessRole() {
        this.inactivityPeriod = 0;
        this.maxFailedLoginCount = 0;
        this.failedLoginInterval = 10;
        this.passwordChangeFreq = 720;
        this.passwordDepth = 0;
    }

    public AccessRole(Integer id) {
        this.id = id;
        this.inactivityPeriod = 0;
        this.maxFailedLoginCount = 0;
        this.failedLoginInterval = 10;
        this.passwordChangeFreq = 720;
        this.passwordDepth = 0;
    }

    public AccessRole(Integer id, String code, String name) {
        this.id = id;
        this.code = code;
        this.name = name;
        this.inactivityPeriod = 0;
        this.maxFailedLoginCount = 0;
        this.failedLoginInterval = 10;
        this.passwordChangeFreq = 720;
        this.passwordDepth = 0;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getSendSmsPinForAuth() {
        return this.sendSmsPinForAuth;
    }

    public void setSendSmsPinForAuth(Boolean sendSmsPinForAuth) {
        this.sendSmsPinForAuth = sendSmsPinForAuth;
    }

    public Integer getMinLengthPassword() {
        return this.minLengthPassword;
    }

    public void setMinLengthPassword(Integer minLengthPassword) {
        this.minLengthPassword = minLengthPassword;
    }

    public Short getAlphabet() {
        if (this.alphabet == null) {
            this.alphabet = 0;
        }
        return this.alphabet;
    }

    public void setAlphabet(Short alphabet) {
        this.alphabet = alphabet;
    }

    public void setLettersAlphabet(Boolean lettersAlphabet) {
        if (lettersAlphabet.booleanValue()) {
            this.setAlphabet((short)(this.getAlphabet() | 1));
        } else {
            this.setAlphabet((short)(this.getAlphabet() & 6));
        }
    }

    public Boolean getLettersAlphabet() {
        if (this.getAlphabet() != null) {
            return (this.getAlphabet() & 1) == 1;
        }
        return Boolean.FALSE;
    }

    public void setNumbersAlphabet(Boolean lettersAlphabet) {
        if (lettersAlphabet.booleanValue()) {
            this.setAlphabet((short)(this.getAlphabet() | 2));
        } else {
            this.setAlphabet((short)(this.getAlphabet() & 5));
        }
    }

    public Boolean getNumbersAlphabet() {
        if (this.getAlphabet() != null) {
            return (this.getAlphabet() & 2) == 2;
        }
        return Boolean.FALSE;
    }

    public void setSymbolsAlphabet(Boolean lettersAlphabet) {
        if (lettersAlphabet.booleanValue()) {
            this.setAlphabet((short)(this.getAlphabet() | 4));
        } else {
            this.setAlphabet((short)(this.getAlphabet() & 3));
        }
    }

    public Boolean getSymbolsAlphabet() {
        if (this.getAlphabet() != null) {
            return (this.getAlphabet() & 4) == 4;
        }
        return Boolean.FALSE;
    }

    public Integer getInactivityPeriod() {
        return this.inactivityPeriod;
    }

    public void setInactivityPeriod(Integer inactivityPeriod) {
        this.inactivityPeriod = inactivityPeriod;
    }

    public Integer getMaxFailedLoginCount() {
        return this.maxFailedLoginCount;
    }

    public void setMaxFailedLoginCount(Integer maxFailedLoginCount) {
        this.maxFailedLoginCount = maxFailedLoginCount;
    }

    public Integer getFailedLoginInterval() {
        return this.failedLoginInterval;
    }

    public void setFailedLoginInterval(Integer failedLoginInterval) {
        this.failedLoginInterval = failedLoginInterval;
    }

    public Integer getPasswordChangeFreq() {
        return this.passwordChangeFreq;
    }

    public void setPasswordChangeFreq(Integer passwordChangeFreq) {
        this.passwordChangeFreq = passwordChangeFreq;
    }

    public Integer getPasswordDepth() {
        return this.passwordDepth;
    }

    public void setPasswordDepth(Integer passwordDepth) {
        this.passwordDepth = passwordDepth;
    }

    public int hashCode() {
        return this._hashCode();
    }

    public boolean equals(Object object) {
        return this._equals(object, AccessRole.class);
    }

    public String toString() {
        return this._toString(AccessRole.class);
    }
}

