/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.api.model.reference.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import ru.softlogic.keeper.annotation.documentation.FieldDoc;
import ru.softlogic.keeper.annotation.documentation.TypeDoc;
import ru.softlogic.keeper.db.model.common.Deletable;

@TypeDoc(value="\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u043e\u043c\u0435\u0440\u043d\u043e\u0439 \u0435\u043c\u043a\u043e\u0441\u0442\u0438")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
public class DTOCapacity
implements Serializable,
Deletable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(value="\u041a\u043e\u0434 \u0441\u0435\u0440\u0432\u0438\u0441\u0430")
    private short code;
    @FieldDoc(value="\u041d\u0430\u0447\u0430\u043b\u043e \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0430")
    private String from;
    @FieldDoc(value="\u041a\u043e\u043d\u0435\u0446 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0430")
    private String to;
    @JsonIgnore
    private long version;
    private boolean deleted;
    private Integer areaId;

    public DTOCapacity() {
    }

    public DTOCapacity(short code, String from, String to, long version, boolean deleted) {
        this.code = code;
        this.from = from;
        this.to = to;
        this.version = version;
        this.deleted = deleted;
    }

    public DTOCapacity(Integer areId, short code, String from, String to, long version, boolean deleted) {
        this(code, from, to, version, deleted);
        this.areaId = areId;
    }

    public Integer getAreaId() {
        return this.areaId;
    }

    public void setAreaId(Integer areaId) {
        this.areaId = areaId;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public short getCode() {
        return this.code;
    }

    public void setCode(short code) {
        this.code = code;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public boolean contain(int phoneLen, String phone) {
        if (this.getFrom().equals(phone)) {
            return true;
        }
        return this.getTo().equals(phone) || phone.length() == phoneLen && this.getFrom().compareTo(phone) < 0 && this.getTo().compareTo(phone) > 0;
    }

    public String toString() {
        return "DTOCapacity [code=" + this.code + ", from='" + this.from + "'" + ", to='" + this.to + "'" + ", area='" + this.areaId + "'" + ", version='" + this.version + "'" + ", deleted='" + this.deleted + "'" + ']';
    }
}

