/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.api.model.client.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import ru.softlogic.keeper.annotation.documentation.FieldDoc;
import ru.softlogic.keeper.annotation.documentation.TypeDoc;
import ru.softlogic.keeper.api.model.client.domain.ExtendedClientInfo;
import ru.softlogic.keeper.db.model.Client;
import ru.softlogic.keeper.db.model.ClientAccount;
import ru.softlogic.keeper.db.model.MenuProfile;
import ru.softlogic.keeper.db.model.OperationTypeMenuRoot;

@TypeDoc(value="\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u0430")
public class DTOClientDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(value="\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043a\u043b\u0438\u0435\u043d\u0442\u0435")
    private Client client;
    @FieldDoc(value="\u041c\u0430\u0441\u0441\u0438\u0432 \u0441\u0447\u0435\u0442\u043e\u0432 \u043a\u043b\u0438\u0435\u043d\u0442\u0430")
    private Collection<ClientAccount> accounts;
    @FieldDoc(value="\u0410\u0441\u0441\u043e\u0446\u0438\u0430\u0442\u0438\u0432\u043d\u044b\u0439 \u043c\u0430\u0441\u0441\u0438\u0432 \u043c\u0435\u043d\u044e \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043f\u043e \u0442\u0438\u043f\u0443 \u043e\u043f\u043b\u0430\u0442\u044b")
    private Map<Short, Integer> cashSourceMenuProfiles;
    @FieldDoc(value="\u041f\u0440\u043e\u0444\u0438\u043b\u044c \u043c\u0435\u043d\u044e", required={"id"})
    private MenuProfile menuProfile;
    @FieldDoc(value="\u041a\u043e\u0440\u043d\u0435\u0432\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u0432 \u043c\u0435\u043d\u044e \u0434\u043b\u044f \u0440\u0430\u0437\u043d\u044b\u0445 \u0442\u0438\u043f\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439")
    private Collection<OperationTypeMenuRoot> menuRoot;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @FieldDoc(value="\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043a\u043b\u0438\u0435\u043d\u0442\u0435")
    private ExtendedClientInfo extendedClientInfo;
    @FieldDoc(value="\u0415\u0441\u0442\u044c \u043b\u0438 \u0443 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0441\u0435\u043a\u0440\u0435\u0442\u043d\u043e\u0435 \u0441\u043b\u043e\u0432\u043e")
    private boolean hasClientSecretKey;
    @FieldDoc(value="\u0418\u0441\u0442\u0435\u043a\u043b\u043e \u043b\u0438 \u0432\u0440\u0435\u043c\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u0430\u0440\u043e\u043b\u044f")
    private boolean passwordExpired;

    public DTOClientDescription() {
    }

    public DTOClientDescription(Client client, Collection<ClientAccount> accounts, Map<Short, Integer> cashSourceMenuProfiles, MenuProfile menuProfile, Collection<OperationTypeMenuRoot> menuRoot) {
        this.client = client;
        this.accounts = accounts;
        this.cashSourceMenuProfiles = cashSourceMenuProfiles;
        this.menuProfile = menuProfile;
        this.menuRoot = menuRoot;
        this.hasClientSecretKey = client != null && client.getSecretKey() != null && client.getSecretKey().length() != 0;
    }

    public DTOClientDescription(Client client, Collection<ClientAccount> accounts, Map<Short, Integer> cashSourceMenuProfiles, MenuProfile menuProfile, Collection<OperationTypeMenuRoot> menuRoot, ExtendedClientInfo extendedClientInfo, boolean passwordExpired) {
        this(client, accounts, cashSourceMenuProfiles, menuProfile, menuRoot);
        this.extendedClientInfo = extendedClientInfo;
        this.passwordExpired = passwordExpired;
    }

    public boolean isHasClientSecretKey() {
        return this.hasClientSecretKey;
    }

    public void setHasClientSecretKey(boolean hasClientSecretKey) {
        this.hasClientSecretKey = hasClientSecretKey;
    }

    public boolean isPasswordExpired() {
        return this.passwordExpired;
    }

    public void setPasswordExpired(boolean passwordExpired) {
        this.passwordExpired = passwordExpired;
    }

    public ExtendedClientInfo getExtendedClientInfo() {
        return this.extendedClientInfo;
    }

    public void setExtendedClientInfo(ExtendedClientInfo extendedClientInfo) {
        this.extendedClientInfo = extendedClientInfo;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Collection<ClientAccount> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(Collection<ClientAccount> accounts) {
        this.accounts = accounts;
    }

    @JsonIgnore
    public boolean isSingleAccount() {
        return this.getAccounts().size() == 1;
    }

    @JsonIgnore
    public ClientAccount getAccount() {
        return this.getAccounts().iterator().next();
    }

    public Map<Short, Integer> getCashSourceMenuProfiles() {
        return this.cashSourceMenuProfiles;
    }

    public void setCashSourceMenuProfiles(Map<Short, Integer> cashSourceMenuProfiles) {
        this.cashSourceMenuProfiles = cashSourceMenuProfiles;
    }

    public MenuProfile getMenuProfile() {
        return this.menuProfile;
    }

    public void setMenuProfile(MenuProfile menuProfile) {
        this.menuProfile = menuProfile;
    }

    public Collection<OperationTypeMenuRoot> getMenuRoot() {
        return this.menuRoot;
    }

    public void setMenuRoot(Collection<OperationTypeMenuRoot> menuRoot) {
        this.menuRoot = menuRoot;
    }

    public String toString() {
        return "DTOClientDescription{client=" + this.client + ", accounts=" + this.accounts + ", cashSourceMenuProfiles=" + this.cashSourceMenuProfiles + ", menuProfile=" + this.menuProfile + ", menuRoot=" + this.menuRoot + ", extendedClientInfo=" + this.extendedClientInfo + ", hasClientSecretKey=" + this.hasClientSecretKey + ", passwordExpired=" + this.passwordExpired + '}';
    }
}

