/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.api.model.autopayment;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import ru.softlogic.keeper.annotation.documentation.FieldDoc;
import ru.softlogic.keeper.annotation.documentation.TypeDoc;
import ru.softlogic.keeper.api.model.DTOAccount;
import ru.softlogic.keeper.api.model.DTOSum;
import ru.softlogic.keeper.db.model.AutoPaymentInterval;
import ru.softlogic.keeper.db.model.CashSource;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@TypeDoc(value="\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436")
public class DTOAutoPayment
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(value="\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430")
    @NotNull
    private DTOAccount account;
    @FieldDoc(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430")
    @NotNull
    @Pattern(regexp="^(?!\\s*$).+")
    private String name;
    @FieldDoc(value="\u0421\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430", required={"outcome"})
    @NotNull
    private DTOSum sum;
    @FieldDoc(value="\u041a\u043e\u0434 \u0430\u043a\u043a\u0430\u0443\u0442\u043d\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0430")
    @Min(value=1L)
    private long clientAccount;
    @FieldDoc(value="\u041a\u043e\u0434 \u0442\u0438\u043f\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438")
    @Min(value=1L)
    private short operationType;
    @FieldDoc(value="\u041f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u043d\u043e\u0441\u0442\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0430", required={"id"})
    @NotNull
    private AutoPaymentInterval autoPaymentInterval;
    @FieldDoc(value="\u0427\u0430\u0441 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0430 (0 - 23)")
    @Min(value=0L)
    @Max(value=23L)
    private short executeHour;
    @FieldDoc(value="\u0424\u043b\u0430\u0433 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438")
    private boolean executeToday;
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0430")
    @NotNull
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date dbegin;
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0430(\u0435\u0441\u043b\u0438 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e, \u0442\u043e \u0431\u0435\u0437\u0441\u0440\u043e\u0447\u043d\u043e)")
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date dend;
    @FieldDoc(value="\u0424\u043b\u0430\u0433 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0430")
    private boolean active;
    @FieldDoc(value="\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u043e\u043f\u043b\u0430\u0442\u044b", required={"id"})
    private CashSource cashSource;

    public DTOAutoPayment() {
    }

    public DTOAutoPayment(DTOAccount account, String name, DTOSum sum, long clientAccount, short operationType, AutoPaymentInterval autoPaymentInterval, short executeHour, boolean executeToday, Date dbegin, Date dend, boolean active) {
        this.account = account;
        this.name = name;
        this.sum = sum;
        this.clientAccount = clientAccount;
        this.operationType = operationType;
        this.autoPaymentInterval = autoPaymentInterval;
        this.executeHour = executeHour;
        this.executeToday = executeToday;
        this.dbegin = dbegin;
        this.dend = dend;
        this.active = active;
    }

    public DTOAccount getAccount() {
        return this.account;
    }

    public void setAccount(DTOAccount account) {
        this.account = account;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DTOSum getSum() {
        return this.sum;
    }

    public void setSum(DTOSum sum) {
        this.sum = sum;
    }

    public long getClientAccount() {
        return this.clientAccount;
    }

    public void setClientAccount(long clientAccount) {
        this.clientAccount = clientAccount;
    }

    public AutoPaymentInterval getAutoPaymentInterval() {
        return this.autoPaymentInterval;
    }

    public void setAutoPaymentInterval(AutoPaymentInterval autoPaymentInterval) {
        this.autoPaymentInterval = autoPaymentInterval;
    }

    public short getExecuteHour() {
        return this.executeHour;
    }

    public void setExecuteHour(short executeHour) {
        this.executeHour = executeHour;
    }

    public boolean isExecuteToday() {
        return this.executeToday;
    }

    public void setExecuteToday(boolean executeToday) {
        this.executeToday = executeToday;
    }

    public Date getDbegin() {
        return this.dbegin;
    }

    public void setDbegin(Date dbegin) {
        this.dbegin = dbegin;
    }

    public Date getDend() {
        return this.dend;
    }

    public void setDend(Date dend) {
        this.dend = dend;
    }

    public short getOperationType() {
        return this.operationType;
    }

    public void setOperationType(short operationType) {
        this.operationType = operationType;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public CashSource getCashSource() {
        return this.cashSource;
    }

    public void setCashSource(CashSource cashSource) {
        this.cashSource = cashSource;
    }

    public String toString() {
        return "DTOAutoPayment{account=" + this.account + ", name='" + this.name + '\'' + ", sum=" + this.sum + ", clientAccount=" + this.clientAccount + ", operationType=" + this.operationType + ", autoPaymentInterval=" + this.autoPaymentInterval + ", executeHour=" + this.executeHour + ", executeToday=" + this.executeToday + ", dbegin=" + this.dbegin + ", dend=" + this.dend + ", active=" + this.active + ", cashSource=" + this.cashSource + '}';
    }
}

