/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public final class FileUtil {
    private FileUtil() {
    }

    public static File checkDir(String path) throws IOException {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("Path not set or empty");
        }
        File file = new File(path);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IOException("Specified path is not a directory");
            }
            if (!file.canExecute()) {
                throw new IOException("No permission for execution");
            }
            if (!file.canRead()) {
                throw new IOException("No permission for reading");
            }
            if (!file.canWrite()) {
                throw new IOException("No permission for writing");
            }
        } else if (!file.mkdirs()) {
            throw new IOException("Directory has not been created");
        }
        return file;
    }

    public static File checkFile(String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Path not set or empty");
        }
        File file = new File(path);
        if (file.exists()) {
            if (!file.isFile()) {
                throw new IOException("The specified path is not a directory");
            }
            if (!file.canRead()) {
                throw new IOException("No permission for reading");
            }
            if (!file.canWrite()) {
                throw new IOException("No permission for writing");
            }
        } else {
            FileUtil.checkDir(file.getParent());
            FileUtil.createFile(file);
        }
        return file;
    }

    private static void createFile(File file) throws IOException {
        if (!file.createNewFile()) {
            throw new IOException("File has not been created");
        }
    }

    public static String readFile(File file) throws IOException {
        return FileUtil.readFile(file, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file, String encoding) throws IOException {
        String string;
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            FileUtil.close(br);
            throw throwable;
        }
        FileUtil.close(br);
        return string;
    }

    public static void writeFile(File file, String content) throws IOException {
        FileUtil.checkFile(file.getAbsolutePath());
        BufferedWriter br = null;
        try {
            br = new BufferedWriter(new FileWriter(file));
            br.write(content, 0, content.length());
            br.flush();
        }
        catch (Throwable throwable) {
            FileUtil.close(br);
            throw throwable;
        }
        FileUtil.close(br);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, InputStream from) throws IOException {
        FileUtil.checkFile(file.getAbsolutePath());
        FileOutputStream fos = null;
        try {
            int len;
            fos = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = from.read(buf)) > -1) {
                fos.write(buf, 0, len);
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(fos);
            FileUtil.close(from);
            throw throwable;
        }
        FileUtil.close(fos);
        FileUtil.close(from);
    }

    public static boolean mkParentDirs(File file) throws IOException {
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            if (!FileUtil.mkParentDirs(parentFile)) {
                throw new IOException(String.format("Directory %s has not been created", parentFile.getAbsolutePath()));
            }
            return parentFile.mkdir();
        }
        return true;
    }

    public static void close(Closeable ... closes) {
        if (closes != null) {
            for (Closeable c : closes) {
                if (c == null) continue;
                try {
                    c.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static final BufferedReader createReader(String path, String encoding) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(path);
            return new BufferedReader(new InputStreamReader((InputStream)fis, encoding));
        }
        catch (IOException ex) {
            FileUtil.close(fis);
            throw ex;
        }
    }
}

