/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.text;

import com.fasterxml.jackson.annotation.JsonInclude;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.ModelEnvironment;
import ru.softlogic.input.model.field.FieldType;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.InputField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TextField
extends InputField {
    public static final long serialVersionUID = 0L;
    private int maxLength;
    private boolean secure;
    private String prefix;
    private String postfix;

    public TextField() {
        this.setType(FieldType.Letter);
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public void init(ModelEnvironment environment) throws InitException {
        Object obj = environment.getData().get(this.id);
        if (obj instanceof InputElement) {
            InputElement ie = (InputElement)environment.getData().get(this.id);
            this.setValue(ie.getOriginalValue());
            String keyTitle = ie.getKeyTitle();
            if ((this.title == null || this.title.isEmpty()) && keyTitle != null && !keyTitle.isEmpty()) {
                this.setTitle(keyTitle);
            }
        } else if (obj == null) {
            this.setValue(this.getDefaultValue());
        } else {
            throw new InitException("TextField " + this.id + " not initialized. Wrong type.");
        }
    }

    @Override
    public String toString() {
        return "TextField{defaultValue=" + this.defaultValue + ", exampleValue=" + this.exampleValue + ", readOnly=" + this.readOnly + ", validator=" + this.validator + ", modificator=" + this.modificator + ", filter=" + this.filter + ", value=" + this.value + ", keyboard=" + this.keyboard + "maxLength=" + this.maxLength + ", secure=" + this.secure + ", prefix=" + this.prefix + ", postfix=" + this.postfix + ", data-formatter=" + this.dataFormatter + '}';
    }
}

