/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.text;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import ru.softlogic.input.model.field.text.Validator;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class RegexValidator
implements Validator {
    private static final long serialVersionUID = 1L;
    private final List<String> rules;
    private final List<String> blockRules;

    @JsonCreator
    public RegexValidator(@JsonProperty(value="rules") List<String> rules, @JsonProperty(value="blockRules") List<String> blockRules) {
        this.rules = rules;
        this.blockRules = blockRules;
    }

    public List<String> getRules() {
        return this.rules;
    }

    public List<String> getBlockRules() {
        return this.blockRules;
    }

    @Override
    public boolean validate(String data) {
        if (data == null) {
            return this.validate("");
        }
        if (this.blockRules != null) {
            for (String regex : this.blockRules) {
                if (!data.matches(regex)) continue;
                return false;
            }
        }
        if (this.rules != null) {
            for (String regex : this.rules) {
                if (!data.matches(regex)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "RegexValidator{rules=" + this.rules + ", blockRules=" + this.blockRules + '}';
    }
}

