/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.text;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import ru.softlogic.input.model.field.text.Formatter;
import ru.softlogic.input.model.field.text.MaskFormatter;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class RegexFormatter
implements Formatter {
    private static final long serialVersionUID = 1L;
    private String defaultMask;
    private Character padding;
    private Map<String, String> masks;
    private boolean byStep;

    public void setByStep(boolean byStep) {
        this.byStep = byStep;
    }

    public boolean isByStep() {
        return this.byStep;
    }

    public String getDefaultMask() {
        return this.defaultMask;
    }

    public Map<String, String> getMasks() {
        return this.masks;
    }

    public void setDefaultMask(String defaultMask) {
        this.defaultMask = defaultMask;
    }

    public void setMasks(Map<String, String> masks) {
        this.masks = masks;
    }

    public Character getPadding() {
        return this.padding;
    }

    public void setPadding(Character padding) {
        this.padding = padding;
    }

    @Override
    public String format(String data) {
        if (data == null) {
            return data;
        }
        if (this.masks != null) {
            for (Map.Entry<String, String> entry : this.masks.entrySet()) {
                try {
                    if (!data.matches(entry.getKey())) continue;
                    MaskFormatter mf = new MaskFormatter(entry.getValue(), this.padding);
                    return mf.format(data);
                }
                catch (Exception tr) {
                    return data;
                }
            }
        }
        if (this.defaultMask != null && this.defaultMask.length() > 0) {
            MaskFormatter mf = new MaskFormatter(this.defaultMask, this.padding);
            return mf.format(data);
        }
        return data;
    }

    public String toString() {
        return "RegexFormatter{defaultMask=" + this.defaultMask + ", masks=" + this.masks + '}';
    }
}

