/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.text;

import ru.softlogic.input.model.field.text.Formatter;

public class NumericFormatter
implements Formatter {
    private static final long serialVersionUID = 1L;
    String inputSeparator;
    String outputSeparator;

    public NumericFormatter(String inputSeparator, String outputSeparator) {
        this.inputSeparator = inputSeparator;
        this.outputSeparator = outputSeparator;
    }

    public String getInputSeparator() {
        return this.inputSeparator;
    }

    public String getOutputSeparator() {
        return this.outputSeparator;
    }

    @Override
    public String format(String data) {
        String decimal = "0";
        String unit = "00";
        if (data != null && !data.isEmpty()) {
            String[] parts = data.split(this.inputSeparator);
            if (parts.length > 0) {
                decimal = parts[0];
            }
            if (parts.length > 1 && !parts[1].isEmpty()) {
                unit = parts[1].length() == 1 ? parts[1] + "0" : parts[1];
            }
        }
        return decimal + this.outputSeparator + unit;
    }
}

