/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.text;

public class MaskFormatter {
    private final String mask;
    private final Character padding;
    private final boolean addTail;
    private final boolean trim;

    public MaskFormatter(String mask) {
        this(mask, null, true, true);
    }

    public MaskFormatter(String mask, Character padding) {
        this(mask, padding, true, true);
    }

    public MaskFormatter(String mask, Character padding, boolean addTail, boolean trim) {
        if (mask == null) {
            throw new NullPointerException("Mask is null");
        }
        if (mask.isEmpty()) {
            throw new IllegalArgumentException("Mask is empty");
        }
        if (!mask.contains("*")) {
            throw new IllegalArgumentException("Mask is not contains masked symbols");
        }
        this.mask = mask;
        this.padding = padding;
        this.addTail = addTail;
        this.trim = trim;
    }

    public String format(String text) {
        if (text == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int j = 0;
        for (int i = 0; i < this.mask.length(); ++i) {
            char mc = this.mask.charAt(i);
            if (mc == '*') {
                if (j < text.length()) {
                    sb.append(text.charAt(j++));
                    continue;
                }
                if (this.padding == null) break;
                sb.append(this.padding);
                continue;
            }
            sb.append(mc);
        }
        if (this.addTail && j < text.length()) {
            sb.append(text.substring(j));
        }
        return this.trim ? sb.toString().trim() : sb.toString();
    }
}

