/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.text;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import ru.softlogic.input.model.field.text.Filter;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class MaskFilter
implements Filter {
    private static final long serialVersionUID = 1L;
    private String mask;

    public MaskFilter() {
    }

    @JsonCreator
    public MaskFilter(@JsonProperty(value="mask") String mask) {
        if (mask == null) {
            throw new NullPointerException("mask");
        }
        this.mask = mask;
    }

    public String getMask() {
        return this.mask;
    }

    @Override
    public boolean isAllowed(char ch, int pos) {
        if (pos < 0 || this.mask.length() <= pos) {
            return false;
        }
        if (this.mask.charAt(pos) == 'd') {
            return Character.isDigit(ch);
        }
        if (this.mask.charAt(pos) == 'c') {
            return Character.isLetter(ch);
        }
        return this.mask.charAt(pos) == '*';
    }
}

