/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.text;

import com.fasterxml.jackson.annotation.JsonInclude;
import ru.softlogic.input.model.field.text.Validator;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class LuhnValidator
implements Validator {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean validate(String data) {
        if (data == null || data.length() != 16 && data.length() != 18) {
            return false;
        }
        int sum = 0;
        for (int i = data.length() - 1; i >= 0; --i) {
            int n = Character.digit(data.charAt(i), 10);
            if (i % 2 == 0 && (n *= 2) > 9) {
                n -= 9;
            }
            sum += n;
        }
        return sum % 10 == 0;
    }
}

