/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.text;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Map;
import ru.softlogic.input.model.field.text.Filter;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CharPermissionFilter
implements Filter {
    private static final long serialVersionUID = 1L;
    private Map<Integer, Rule> rules;

    public CharPermissionFilter() {
    }

    public CharPermissionFilter(@JsonProperty(value="rules") Map<Integer, Rule> rules) {
        if (rules == null) {
            throw new NullPointerException("Rules not set");
        }
        this.rules = rules;
    }

    public Map<Integer, Rule> getRules() {
        return this.rules;
    }

    public void setRules(Map<Integer, Rule> rules) {
        this.rules = rules;
    }

    @Override
    public boolean isAllowed(char ch, int pos) {
        Rule rule = this.rules.get(pos);
        if (rule != null) {
            return rule.isAllowed(ch);
        }
        return true;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    public static class Rule
    implements Serializable {
        public static final int TYPE_DENY = 0;
        public static final int TYPE_ALLOW = 1;
        private static final long serialVersionUID = 1L;
        private int type;
        private String value;

        public Rule() {
        }

        public Rule(int type, String value) {
            this.type = type;
            this.value = value;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isAllowed(char ch) {
            boolean contains = this.value.startsWith("^") && this.value.endsWith("$") ? Character.toString(ch).matches(this.value) : this.value.contains(String.valueOf(ch));
            return this.type == 1 ? contains : !contains;
        }
    }
}

