/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.text;

import java.text.ParseException;
import javax.swing.text.MaskFormatter;
import ru.softlogic.input.model.field.text.Formatter;

public class AutoFormatter
implements Formatter {
    private static final long serialVersionUID = 1L;
    private static String del;

    @Override
    public String format(String data) {
        if (data == null || data.isEmpty()) {
            return data;
        }
        if (data.matches("\\d+")) {
            if (data.length() <= 4) {
                return data;
            }
            if (data.length() <= 6) {
                return this.format(data, "***" + this.getDelimiter() + "***");
            }
            return this.format(data, this.getMask(data));
        }
        return data;
    }

    private String format(String data, String mask) {
        try {
            MaskFormatter formatter = new MaskFormatter(mask);
            formatter.setValueContainsLiteralCharacters(false);
            return formatter.valueToString(data);
        }
        catch (ParseException parseException) {
            return data;
        }
    }

    private String getMask(String data) {
        int count = data.length() / 4 + (data.length() % 4 == 0 ? 0 : 1);
        String res = "";
        for (int i = 0; i < count; ++i) {
            res = res + (res.isEmpty() ? "****" : this.getDelimiter() + "****");
        }
        return res;
    }

    private synchronized String getDelimiter() {
        if (del == null) {
            String d = System.getProperty("formatter.auto.delimiter");
            del = d != null && d.length() == 1 && d.matches(" |-|/") ? d : " ";
        }
        return del;
    }
}

