/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.table;

import java.util.LinkedList;
import java.util.List;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.ModelEnvironment;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.table.TableItem;
import ru.softlogic.input.model.field.table.TableStore;

public class TableDataStore
implements TableStore {
    static final long serialVersionUID = 0L;
    private final String key;
    private List<Data> dataSource;
    private List<TableItem> result;

    public TableDataStore(String key) {
        this.key = key;
    }

    @Override
    public void init(ModelEnvironment environment) throws InitException {
        this.result = null;
        Object obj = environment.getData().get(this.key);
        if (obj == null) {
            throw new InitException("TableDataStore " + this.key + " is not initialized. No data.");
        }
        if (!(obj instanceof List)) {
            throw new InitException("TableDataStore " + this.key + " is not initialized. Wrong type.");
        }
        this.dataSource = (List)obj;
    }

    @Override
    public List<TableItem> getTableItems() {
        if (this.result == null && this.dataSource != null) {
            this.result = new LinkedList<TableItem>();
            for (Data d : this.dataSource) {
                TableItem ti = new TableItem();
                ti.setData(d);
                ti.setElements(StoreHelper.convert(d.getElements()));
                this.result.add(ti);
            }
        }
        return this.result;
    }
}

