/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.selector.custom;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import ru.softlogic.input.model.field.ScreenSequence;
import ru.softlogic.input.model.field.selector.custom.CustomData;
import ru.softlogic.input.model.field.selector.custom.RedirectCustomData;
import ru.softlogic.input.model.field.selector.custom.SequenceCustomData;

class CustomDataDeserializer
extends JsonDeserializer<CustomData> {
    CustomDataDeserializer() {
    }

    public CustomData deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectCodec oc = jp.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jp);
        JsonNode classTag = node.get("@cls");
        if (classTag != null) {
            if ("cd-redirect".equals(classTag.asText())) {
                short service = (short)node.get("service").asInt();
                JsonNode paramsNode = node.get("params");
                if (paramsNode != null) {
                    List params = (List)objectMapper.readValue(paramsNode.toString(), List.class);
                    return new RedirectCustomData(service, params);
                }
                return new RedirectCustomData(service);
            }
            if ("cd-sequence".equals(classTag.asText())) {
                String sequenceStr = node.get("screenSequence").toString();
                ScreenSequence screenSequence = (ScreenSequence)objectMapper.readValue(sequenceStr, ScreenSequence.class);
                return new SequenceCustomData(screenSequence);
            }
        }
        return null;
    }
}

