/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.selector;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Serializable;
import java.util.Map;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.advanced.configuration.SoftwareType;
import ru.softlogic.input.model.field.selector.custom.CustomData;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class SelectorItem
implements Serializable {
    static final long serialVersionUID = 0L;
    private String title;
    private String titleId;
    private String value;
    private String image;
    private boolean enable = true;
    private String help;
    private String helpTemplate;
    private Data data;
    @JsonDeserialize(contentAs=CustomData.class)
    private Map<String, Object> customData;
    private Map<SoftwareType, String> helpTplBySoftwateType;
    private Map<SoftwareType, String> helpMap;

    public SelectorItem() {
    }

    public SelectorItem(String title, String value) {
        this.title = title;
        this.value = value;
    }

    public SelectorItem(String title, String titleId, String value, String image, boolean enable) {
        this.title = title;
        this.titleId = titleId;
        this.value = value;
        this.image = image;
        this.enable = enable;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public String getHelpTemplate() {
        return this.helpTemplate;
    }

    public void setHelpTemplate(String helpTemplate) {
        this.helpTemplate = helpTemplate;
    }

    public void setHelpBySoftwareType(Map<SoftwareType, String> helpMap) {
        if (helpMap != null) {
            this.help = helpMap.get((Object)SoftwareType.Any);
        }
        this.helpMap = helpMap;
    }

    public String getHelpBySoftwareType(SoftwareType type) {
        if (this.helpMap != null) {
            String helpValue = this.helpMap.get((Object)type);
            if (helpValue != null) {
                return helpValue;
            }
            return this.helpMap.get((Object)SoftwareType.Any);
        }
        return null;
    }

    public Map<SoftwareType, String> getHelpTplBySoftwateType() {
        return this.helpTplBySoftwateType;
    }

    public void setHelpTplBySoftwateType(Map<SoftwareType, String> helpTemplateMap) {
        if (helpTemplateMap != null) {
            this.helpTemplate = helpTemplateMap.get((Object)SoftwareType.Any);
        }
        this.helpTplBySoftwateType = helpTemplateMap;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Data getData() {
        return this.data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public Map<String, Object> getCustomData() {
        return this.customData;
    }

    public void setCustomData(Map<String, Object> customData) {
        this.customData = customData;
    }

    public String getTitleId() {
        return this.titleId;
    }

    public void setTitleId(String titleId) {
        this.titleId = titleId;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelectorItem other = (SelectorItem)obj;
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        if (this.titleId == null ? other.titleId != null : !this.titleId.equals(other.titleId)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        if (this.image == null ? other.image != null : !this.image.equals(other.image)) {
            return false;
        }
        if (this.help == null ? other.help != null : !this.help.equals(other.help)) {
            return false;
        }
        return !(this.helpTemplate != null ? !this.helpTemplate.equals(other.helpTemplate) : other.helpTemplate != null);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.title != null ? this.title.hashCode() : 0);
        hash = 89 * hash + (this.titleId != null ? this.titleId.hashCode() : 0);
        hash = 89 * hash + (this.value != null ? this.value.hashCode() : 0);
        hash = 89 * hash + (this.image != null ? this.image.hashCode() : 0);
        hash = 89 * hash + (this.help != null ? this.help.hashCode() : 0);
        hash = 89 * hash + (this.helpTemplate != null ? this.helpTemplate.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "SelectorItem{title=" + this.title + ", titleId=" + this.titleId + ", value=" + this.value + ", image=" + this.image + ", enable=" + this.enable + ", help=" + this.helpMap + ", helpTemplate=" + this.helpTemplate + ", data=" + this.data + ", customData=" + this.customData + '}';
    }
}

