/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.numeric;

import com.fasterxml.jackson.annotation.JsonInclude;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.ModelEnvironment;
import ru.softlogic.input.model.field.FieldType;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.InputField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class NumericField
extends InputField {
    public static final long serialVersionUID = 0L;
    private int unitCount;
    private int decimalCount;
    private double updown;

    public NumericField() {
        this.setType(FieldType.Numeric);
    }

    public int getDecimalCount() {
        return this.decimalCount;
    }

    public void setDecimalCount(int decimalCount) {
        this.decimalCount = decimalCount;
    }

    public int getUnitCount() {
        return this.unitCount;
    }

    public void setUnitCount(int unitCount) {
        this.unitCount = unitCount;
    }

    public double getUpdown() {
        return this.updown;
    }

    public void setUpdown(double updown) {
        this.updown = updown;
    }

    @Override
    public String toString() {
        return "NumericField[id=" + this.getId() + ",format=" + this.unitCount + "." + this.decimalCount + ", validator=" + this.getValidator() + ']';
    }

    @Override
    public void init(ModelEnvironment environment) throws InitException {
        Object object = environment.getData().get(this.getId());
        if (object instanceof InputElement) {
            InputElement ie = (InputElement)object;
            String keyTitle = ie.getKeyTitle();
            if ((this.title == null || this.title.isEmpty()) && keyTitle != null && !keyTitle.isEmpty()) {
                this.setTitle(keyTitle);
            }
            this.setValue(ie.getValue());
        } else {
            this.setValue(this.getDefaultValue());
        }
    }
}

