/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.ModelEnvironment;
import ru.softlogic.input.model.field.FieldType;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.date.DateRange;
import ru.softlogic.input.model.field.date.Range;
import ru.softlogic.input.model.field.date.RelativeDateRange;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DateField
extends IdentityField {
    public static final long serialVersionUID = 0L;
    public static final String JSON_FORMAT = "yyyy-MM-dd";
    @JsonProperty(value="format")
    private String format;
    @JsonProperty(value="formatTitle")
    private String formatTitle;
    @JsonFormat(pattern="yyyy-MM-dd")
    @JsonProperty(value="from")
    private Date from;
    @JsonFormat(pattern="yyyy-MM-dd")
    @JsonProperty(value="to")
    private Date to;
    @JsonFormat(pattern="yyyy-MM-dd")
    @JsonProperty(value="curr")
    private Date curr;
    @JsonFormat(pattern="yyyy-MM-dd")
    @JsonProperty(value="value")
    private Date value;
    private SimpleDateFormat formater;
    private SimpleDateFormat formaterTitle;
    @JsonProperty(value="dateRange")
    private DateRange dateRange;
    private static final DateRange defaultDateRange = new RelativeDateRange(0, 90, 0);

    public DateField() {
        this.setType(FieldType.Date);
    }

    public void setDateRange(DateRange dateRange) {
        if (dateRange == null) {
            throw new NullPointerException("DateRange is null");
        }
        this.dateRange = dateRange;
    }

    public void setFormat(String format) {
        this.format = format;
        this.formater = new SimpleDateFormat(format);
    }

    public void setFormatTitle(String format) {
        this.formatTitle = format == null ? this.format : format;
        this.formaterTitle = new SimpleDateFormat(this.formatTitle);
    }

    @JsonIgnore
    public SimpleDateFormat getFormater() {
        return this.formater;
    }

    @JsonIgnore
    public SimpleDateFormat getFormaterTitle() {
        return this.formaterTitle;
    }

    public String getFormat() {
        return this.format;
    }

    public String getFormatTitle() {
        return this.formatTitle;
    }

    public boolean isValid(Date d) {
        if (this.from != null && d.compareTo(this.from) < 0) {
            return false;
        }
        return this.to == null || d.compareTo(this.to) <= 0;
    }

    public void setValue(Date value) {
        this.value = value;
    }

    public Date getValue() {
        return this.value;
    }

    public Date getFrom() {
        return this.from;
    }

    public Date getTo() {
        return this.to;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public void init(ModelEnvironment environment) throws InitException {
        Range r = this.dateRange != null ? this.dateRange.getRange() : defaultDateRange.getRange();
        this.from = r.getFrom();
        this.to = r.getTo();
        this.curr = r.getCurrent();
        Object obj = environment.getData().get(this.getId());
        try {
            if (obj != null && obj instanceof InputElement) {
                InputElement ie = (InputElement)environment.getData().get(this.getId());
                this.value = this.formater.parse(ie.getValue());
            } else {
                this.value = this.curr;
            }
        }
        catch (ParseException ex) {
            throw new InitException("Error on parsing " + obj, ex);
        }
    }

    @Override
    public String toString() {
        return "DateField{format=" + this.format + ", formatTitle=" + this.formatTitle + ", dateRange=" + this.dateRange + ", formater=" + this.formater + ", formaterTitle=" + this.formaterTitle + '}';
    }
}

