/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.date;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import ru.softlogic.input.model.field.date.DateRange;
import ru.softlogic.input.model.field.date.Range;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AbsoluteDateRange
implements DateRange {
    public static final long serialVersionUID = 0L;
    @JsonProperty(value="range")
    private Range range;

    public AbsoluteDateRange() {
    }

    @JsonCreator
    public AbsoluteDateRange(@JsonProperty(value="range") Range range) {
        this.range = range;
    }

    public AbsoluteDateRange(Date from, Date to, Date current) {
        if (from != null && to != null && from.after(to)) {
            throw new IllegalArgumentException("'From' must be less 'to'");
        }
        if (current == null) {
            current = new Date();
        }
        if (from != null && current.before(from) || to != null && current.after(to)) {
            throw new IllegalArgumentException("Current value must be in range " + from + "main" + to);
        }
        this.range = new Range(from, to, current);
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public String toString() {
        return "AbsoluteDateRange{range=" + this.range + '}';
    }
}

