/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.checkbox;

import java.util.Map;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.ModelEnvironment;
import ru.softlogic.input.model.advanced.configuration.SoftwareType;
import ru.softlogic.input.model.field.FieldType;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.InputField;

public class CheckBoxField
extends InputField {
    public static final long serialVersionUID = 0L;
    private String messageOff;
    private String messageOffId;
    private String text;
    private Map<SoftwareType, String> helpOff;
    private String helpOffId;

    public CheckBoxField() {
        this.setType(FieldType.CheckBox);
    }

    public String getMessageOff() {
        return this.messageOff;
    }

    public void setMessageOff(String messageOff) {
        this.messageOff = messageOff;
    }

    public String getMessageOffId() {
        return this.messageOffId;
    }

    public void setMessageOffId(String messageOffId) {
        this.messageOffId = messageOffId;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Map<SoftwareType, String> getHelpOff() {
        return this.helpOff;
    }

    public void setHelpOff(Map<SoftwareType, String> helpOff) {
        this.helpOff = helpOff;
    }

    public String getHelpOffId() {
        return this.helpOffId;
    }

    public void setHelpOffId(String helpOffId) {
        this.helpOffId = helpOffId;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getHelpOffBySoftwareType(SoftwareType type) {
        if (this.helpOff == null) {
            return null;
        }
        String helpValue = this.helpOff.get((Object)type);
        if (helpValue == null && (type == SoftwareType.Keeper_Android || type == SoftwareType.Keeper_Ios || type == SoftwareType.Keeper_Web)) {
            helpValue = this.helpOff.get((Object)SoftwareType.Keeper);
        }
        return helpValue != null ? helpValue : this.helpOff.get((Object)SoftwareType.Any);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init(ModelEnvironment environment) throws InitException {
        Object obj = environment.getData().get(this.getId());
        if (obj != null) {
            if (!(obj instanceof InputElement)) throw new InitException("CheckBoxField " + this.getId() + " is not initialized. Wrong type.");
            InputElement ie = (InputElement)environment.getData().get(this.getId());
            this.setValue(ie.getOriginalValue());
            if (this.getTitle() != null && !this.getTitle().isEmpty() || ie.getKeyTitle() == null || ie.getKeyTitle().isEmpty()) return;
            this.setTitle(ie.getKeyTitle());
            return;
        } else {
            this.setValue(this.getDefaultValue());
        }
    }

    @Override
    public String toString() {
        return "CheckBoxField{messageOff=" + this.messageOff + ", messageOffId=" + this.messageOffId + ", text=" + this.text + ", helpOff=" + this.helpOff + ", helpOffId=" + this.helpOffId + '}';
    }
}

