/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.barcode.mur;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.barcode.BarcodeData;
import ru.softlogic.input.model.field.barcode.BarcodeException;
import ru.softlogic.input.model.field.barcode.BarcodeParser;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ERCParser
implements BarcodeParser {
    public static final long serialVersionUID = 0L;
    private final Map<Character, Integer> table = new HashMap<Character, Integer>();

    public ERCParser() {
        this.table.put(Character.valueOf('0'), 0);
        this.table.put(Character.valueOf('1'), 1);
        this.table.put(Character.valueOf('2'), 2);
        this.table.put(Character.valueOf('3'), 3);
        this.table.put(Character.valueOf('4'), 4);
        this.table.put(Character.valueOf('5'), 5);
        this.table.put(Character.valueOf('6'), 6);
        this.table.put(Character.valueOf('7'), 7);
        this.table.put(Character.valueOf('8'), 8);
        this.table.put(Character.valueOf('9'), 9);
        this.table.put(Character.valueOf('A'), 10);
        this.table.put(Character.valueOf('B'), 11);
        this.table.put(Character.valueOf('C'), 12);
        this.table.put(Character.valueOf('D'), 13);
        this.table.put(Character.valueOf('E'), 14);
        this.table.put(Character.valueOf('F'), 15);
        this.table.put(Character.valueOf('G'), 16);
        this.table.put(Character.valueOf('H'), 17);
        this.table.put(Character.valueOf('I'), 18);
        this.table.put(Character.valueOf('J'), 19);
        this.table.put(Character.valueOf('K'), 20);
        this.table.put(Character.valueOf('L'), 21);
        this.table.put(Character.valueOf('M'), 22);
        this.table.put(Character.valueOf('N'), 23);
        this.table.put(Character.valueOf('O'), 24);
        this.table.put(Character.valueOf('P'), 25);
        this.table.put(Character.valueOf('Q'), 26);
        this.table.put(Character.valueOf('R'), 27);
        this.table.put(Character.valueOf('S'), 28);
        this.table.put(Character.valueOf('T'), 29);
        this.table.put(Character.valueOf('U'), 30);
        this.table.put(Character.valueOf('V'), 31);
        this.table.put(Character.valueOf('W'), 32);
        this.table.put(Character.valueOf('X'), 33);
        this.table.put(Character.valueOf('Y'), 34);
        this.table.put(Character.valueOf('Z'), 35);
        this.table.put(Character.valueOf('$'), 36);
        this.table.put(Character.valueOf('%'), 37);
        this.table.put(Character.valueOf(' '), 38);
        this.table.put(Character.valueOf('-'), 39);
        this.table.put(Character.valueOf('+'), 40);
        this.table.put(Character.valueOf('.'), 41);
        this.table.put(Character.valueOf('/'), 42);
    }

    public int decode(String value) {
        int result = 0;
        for (int i = 0; i < value.length(); ++i) {
            result *= 43;
            result += this.table.get(Character.valueOf(value.charAt(i))).intValue();
        }
        return result;
    }

    public int calcCrc(String value) {
        int xor = 0;
        int sum = 0;
        for (int i = 0; i < value.length(); ++i) {
            int c = value.charAt(i);
            if (c == 32) {
                c = 95;
            }
            if ((sum += c) >= 1024) {
                sum += sum / 1024;
                sum %= 1024;
            }
            xor ^= c;
        }
        return (sum & 0x3FF) + (xor & 0x3FF);
    }

    @Override
    public BarcodeData parse(String data) throws BarcodeException {
        if (data == null || data.length() < 4) {
            throw new BarcodeException("Data not correct");
        }
        if (data.startsWith("E")) {
            if (data.length() != 13) {
                throw new BarcodeException("Length is not correct");
            }
            if (this.calcCrc(data.substring(0, data.length() - 2)) != this.decode(data.substring(data.length() - 2))) {
                throw new BarcodeException("Crc not correct");
            }
            InputElement account = new InputElement("account", "\u041d\u043e\u043c\u0435\u0440 \u043b\u0438\u0446\u0435\u0432\u043e\u0433\u043e \u0441\u0447\u0435\u0442\u0430", Integer.toString(this.decode(data.substring(1, 5))));
            InputElement debt = new InputElement("debt", "\u0421\u0443\u043c\u043c\u0430 \u043e\u043f\u043b\u0430\u0442\u044b", Integer.toString(this.decode(data.substring(5, 10))));
            InputElement ccode = new InputElement("ccode", "\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0435 \u0447\u0438\u0441\u043b\u043e", data.substring(10, 11));
            return new BarcodeData(account, debt, ccode);
        }
        if (data.startsWith("W")) {
            if (data.length() != 12) {
                throw new BarcodeException("Length is not correct");
            }
            if (this.calcCrc(data.substring(0, data.length() - 2)) != this.decode(data.substring(data.length() - 2))) {
                throw new BarcodeException("Crc not correct");
            }
            InputElement account = new InputElement("p_account", "\u041d\u043e\u043c\u0435\u0440 \u043b\u0438\u0446\u0435\u0432\u043e\u0433\u043e \u0441\u0447\u0435\u0442\u0430", Integer.toString(this.decode(data.substring(1, 5))));
            InputElement debt = new InputElement("penalty", "\u041f\u0435\u043d\u044f", Integer.toString(this.decode(data.substring(5, 10))));
            return new BarcodeData(account, debt);
        }
        if (data.startsWith("R")) {
            if (data.length() != 6) {
                throw new BarcodeException("Length is not correct");
            }
            if (this.calcCrc(data.substring(0, data.length() - 2)) != this.decode(data.substring(data.length() - 2))) {
                throw new BarcodeException("Crc not correct");
            }
            InputElement insurance = new InputElement("insurance", "\u0414\u043e\u0431\u0440\u043e\u0432\u043e\u043b\u044c\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u0445\u043e\u0432\u043a\u0430", Integer.toString(this.decode(data.substring(5, 10))));
            return new BarcodeData(insurance);
        }
        throw new BarcodeException("Unknown type");
    }
}

