/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.autocomplete;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.ModelEnvironment;
import ru.softlogic.input.model.advanced.configuration.RuntimeConfiguration;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.autocomplete.AutoCompleteOrderType;
import ru.softlogic.input.model.field.autocomplete.DataPartial;
import ru.softlogic.input.model.field.autocomplete.DataStore;
import ru.softlogic.input.model.utils.FileUtil;

public class PlainDataStore
implements DataStore {
    private final String fileName;
    private final String defaultElement;
    private final DataPartial partial;
    private final String[] filters;
    private List<InputElement> filterList;
    private List<List<InputElementRateWrapper>> elements;
    private int hash;
    private boolean change;
    private final AutoCompleteOrderType orderType;
    private final Pattern valuePattern = Pattern.compile("(.*)\\[(-?\\d{1,3})\\]");

    public PlainDataStore(String fileName, String defaultElement, DataPartial partial, String[] filters) {
        this.fileName = fileName;
        this.defaultElement = defaultElement;
        this.partial = partial;
        this.filters = filters;
        this.orderType = AutoCompleteOrderType.NAME;
    }

    public PlainDataStore(String fileName, String defaultElement, DataPartial partial, String[] filters, AutoCompleteOrderType orderType) {
        this.fileName = fileName;
        this.defaultElement = defaultElement;
        this.partial = partial;
        this.filters = filters;
        this.orderType = orderType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public DataPartial getPartial() {
        return this.partial;
    }

    public String[] getFilters() {
        return this.filters;
    }

    @Override
    public boolean elementsIsChange() {
        return this.change;
    }

    @Override
    public InputElement getDefaultElement() {
        if (this.defaultElement != null && !this.defaultElement.isEmpty()) {
            for (List<InputElementRateWrapper> element : this.elements) {
                InputElement ie = element.get(this.filterList.size());
                if (!this.defaultElement.equals(ie.getValue())) continue;
                return ie;
            }
        }
        return null;
    }

    @Override
    public List<InputElement> getElements(String phrase, int maxItems) {
        int size = this.filterList.size();
        ArrayList<InputElementRateWrapper> result = new ArrayList<InputElementRateWrapper>();
        for (List<InputElementRateWrapper> list : this.elements) {
            InputElementRateWrapper ie;
            if (size >= list.size() || !this.partial.isMatch(phrase, ie = list.get(size)) || !this.filter(list, this.filterList)) continue;
            result.add(ie);
        }
        List<InputElementRateWrapper> list = this.uniqueList(result);
        Collections.sort(list, new InputElementComparator(phrase, this.orderType));
        return this.partial.filter(list, phrase, maxItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void init(ModelEnvironment environment) throws InitException {
        File dsDir = RuntimeConfiguration.getInstance().getDsPath();
        if (dsDir == null) {
            throw new InitException("RuntimeConfiguration is not inited, you must set-up data-source dir");
        }
        File source = new File(dsDir, this.fileName);
        if (!source.exists() || !source.canRead()) {
            Object element = environment.getData().get(this.fileName);
            if (element instanceof InputElement) {
                source = new File(dsDir, ((InputElement)element).getValue());
            }
            if (!source.exists() || !source.canRead()) {
                throw new InitException("Auto complete file does not exist or can not be read: " + source.getAbsolutePath());
            }
        }
        this.filterList = new ArrayList<InputElement>();
        if (this.filters != null) {
            Map<String, Object> data = environment.getData();
            for (String filter : this.filters) {
                Object object = data.get(filter);
                if (!(object instanceof InputElement)) continue;
                this.filterList.add((InputElement)object);
            }
        }
        boolean bl = this.change = this.calculateHashCode(source.getAbsolutePath(), this.filterList) != this.hash;
        if (this.change) {
            this.elements = new ArrayList<List<InputElementRateWrapper>>();
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(source));
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    this.elements.add(this.createInputElement(source.getAbsolutePath(), line));
                }
            }
            catch (IOException iOException) {
                FileUtil.close(reader);
                catch (Throwable throwable) {
                    FileUtil.close(reader);
                    throw throwable;
                }
            }
            FileUtil.close(reader);
        }
        if (this.hash == 0) {
            this.change = false;
        }
        this.hash = this.calculateHashCode(source.getAbsolutePath(), this.filterList);
    }

    private List<InputElementRateWrapper> createInputElement(String fileName, String line) {
        String[] blocks = line.split(";");
        ArrayList<InputElementRateWrapper> result = new ArrayList<InputElementRateWrapper>();
        for (String block : blocks) {
            String[] elems = block.split(":");
            InputElementRateWrapper ie = new InputElementRateWrapper();
            if (elems.length == 0) {
                throw new RuntimeException("Bad input element. File: " + fileName + " line: " + line);
            }
            String value = elems[0];
            Matcher matcher = this.valuePattern.matcher(value);
            if (matcher.find()) {
                String strRate = matcher.group(2);
                ie.setRate(Integer.parseInt(strRate));
                value = matcher.group(1);
            }
            if (elems.length == 1) {
                ie.setValue(value);
                ie.setOriginalValue(value);
                ie.setValueTitle(value);
            } else if (elems.length >= 2) {
                ie.setValue(value);
                ie.setOriginalValue(value);
                ie.setValueTitle(elems[1]);
                for (int n = 2; n < elems.length; ++n) {
                    ie.getAlternatives().add(elems[n]);
                }
            }
            result.add(ie);
        }
        return result;
    }

    private List<InputElementRateWrapper> uniqueList(List<InputElementRateWrapper> list) {
        LinkedList<InputElementRateWrapper> result = new LinkedList<InputElementRateWrapper>();
        for (InputElementRateWrapper element : list) {
            boolean unique = true;
            for (InputElement inputElement : result) {
                if (!inputElement.getValue().equals(element.getValue())) continue;
                unique = false;
                break;
            }
            if (!unique) continue;
            result.add(element);
        }
        return result;
    }

    private boolean filter(List<InputElementRateWrapper> list, List<InputElement> filters) {
        for (int i = 0; i < filters.size(); ++i) {
            if (list.get(i).getValue().equals(filters.get(i).getValue())) continue;
            return false;
        }
        return true;
    }

    private int calculateHashCode(String fileName, List<InputElement> list) {
        int hashCode = 0;
        for (InputElement ie : list) {
            hashCode += ie.getValue().hashCode();
        }
        return hashCode + fileName.hashCode();
    }

    private static class InputElementComparator
    implements Comparator<InputElementRateWrapper>,
    Serializable {
        static final long serialVersionUID = 0L;
        private final String phrase;
        private final AutoCompleteOrderType orderType;

        public InputElementComparator(String phrase, AutoCompleteOrderType orderType) {
            this.phrase = phrase.toLowerCase();
            this.orderType = orderType;
        }

        @Override
        public int compare(InputElementRateWrapper o1, InputElementRateWrapper o2) {
            boolean r1 = o1.getValueTitle().toLowerCase().startsWith(this.phrase);
            boolean r2 = o2.getValueTitle().toLowerCase().startsWith(this.phrase);
            if (r1 && !r2 || o1.getRate() > o2.getRate() && AutoCompleteOrderType.RATE.equals((Object)this.orderType)) {
                return -1;
            }
            if (!r1 && r2 || o1.getRate() < o2.getRate() && AutoCompleteOrderType.RATE.equals((Object)this.orderType)) {
                return 1;
            }
            return o1.getValueTitle().toLowerCase().compareTo(o2.getValueTitle().toLowerCase());
        }
    }

    private class InputElementRateWrapper
    extends InputElement {
        private static final long serialVersionUID = 1L;
        private int rate;

        private InputElementRateWrapper() {
        }

        public int getRate() {
            return this.rate;
        }

        public void setRate(int rate) {
            this.rate = rate;
        }
    }
}

