/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field;

import com.fasterxml.jackson.annotation.JsonInclude;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.text.Filter;
import ru.softlogic.input.model.field.text.Formatter;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.Modificator;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.input.model.field.text.VoidFilter;
import ru.softlogic.input.model.field.text.VoidFormatter;
import ru.softlogic.input.model.field.text.VoidModificator;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class InputField
extends IdentityField {
    protected String defaultValue;
    protected String exampleValue;
    protected boolean readOnly;
    protected Validator validator;
    protected Modificator modificator;
    protected Formatter viewFormatter;
    protected Formatter dataFormatter;
    protected Filter filter = new VoidFilter();
    protected String value;
    protected Keyboard keyboard;
    protected String failRegex;

    public InputField() {
        this.modificator = new VoidModificator();
        this.viewFormatter = new VoidFormatter();
        this.dataFormatter = new VoidFormatter();
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getExampleValue() {
        return this.exampleValue;
    }

    public void setExampleValue(String exampleValue) {
        this.exampleValue = exampleValue;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
        this.required = validator == null ? false : !validator.validate("");
    }

    public Modificator getModificator() {
        return this.modificator;
    }

    public void setModificator(Modificator modificator) {
        this.modificator = modificator;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public Keyboard getKeyboard() {
        return this.keyboard;
    }

    public void setKeyboard(Keyboard keyboard) {
        this.keyboard = keyboard;
    }

    public Formatter getDataFormatter() {
        return this.dataFormatter;
    }

    public void setDataFormatter(Formatter dataFormatter) {
        this.dataFormatter = dataFormatter;
    }

    public String getFailRegex() {
        return this.failRegex;
    }

    public void setFailRegex(String failRegex) {
        this.failRegex = failRegex;
    }

    public Formatter getViewFormatter() {
        return this.viewFormatter;
    }

    public void setViewFormatter(Formatter viewFormatter) {
        this.viewFormatter = viewFormatter;
    }

    public void setFormatter(Formatter formatter) {
        this.viewFormatter = formatter;
        this.dataFormatter = formatter;
    }
}

