/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.expression.calculator;

import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.expression.calculator.CalculateException;

public final class ExpressionCalculator {
    private static volatile ScriptEngine engine;

    private ExpressionCalculator() {
    }

    public static Object calculate(String expr, Map<String, Object> data) throws CalculateException {
        if (expr == null || expr.trim().isEmpty()) {
            throw new IllegalArgumentException("Need expression");
        }
        if (data == null) {
            throw new IllegalArgumentException("Need data");
        }
        try {
            engine = ExpressionCalculator.getEngine();
            engine.setContext(ExpressionCalculator.createContext(data));
            return engine.eval(expr);
        }
        catch (ScriptException ex) {
            throw new CalculateException(ex.getMessage(), ex);
        }
    }

    private static SimpleScriptContext createContext(Map<String, Object> data) {
        SimpleScriptContext engineContext = new SimpleScriptContext();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof InputElement)) continue;
            String value1 = ((InputElement)value).getValue();
            try {
                if (value1 == null) continue;
                engineContext.setAttribute(entry.getKey(), Double.parseDouble(value1), 100);
            }
            catch (NumberFormatException ex) {
                engineContext.setAttribute(entry.getKey(), value1, 100);
            }
        }
        return engineContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ScriptEngine getEngine() {
        if (engine != null) return engine;
        Class<ExpressionCalculator> clazz = ExpressionCalculator.class;
        synchronized (ExpressionCalculator.class) {
            ScriptEngineManager manager = new ScriptEngineManager();
            engine = manager.getEngineByName("js");
            // ** MonitorExit[var0] (shouldn't be in output)
            return engine;
        }
    }
}

