/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.validator.sequence;

import java.util.Map;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.advanced.actions.ExecuteException;
import ru.softlogic.input.model.advanced.actions.validator.sequence.SequenceGenerator;
import ru.softlogic.input.model.advanced.actions.validator.sequence.util.Sequence;
import ru.softlogic.input.model.advanced.actions.validator.sequence.util.SequenceManager;

public class SimpleSequenceGenerator
implements SequenceGenerator {
    public static final long serialVersionUID = 0L;
    private String name;
    private String start;
    private String end;
    private boolean loop;
    private String resultKey;
    private String resultTitle;
    private ActionMap actionMap;
    private boolean noIncrement;

    public String getName() {
        return this.name;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public String getResultKey() {
        return this.resultKey;
    }

    public String getResultTitle() {
        return this.resultTitle;
    }

    public ActionMap getActionMap() {
        return this.actionMap;
    }

    public boolean isNoIncrement() {
        return this.noIncrement;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public void setResultKey(String resultKey) {
        this.resultKey = resultKey;
    }

    public void setResultTitle(String resultTitle) {
        this.resultTitle = resultTitle;
    }

    public void setActionMap(ActionMap actionMap) {
        this.actionMap = actionMap;
    }

    public void setNoIncrement(boolean noIncrement) {
        this.noIncrement = noIncrement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(ActionContext context) throws ExecuteException {
        Map<String, String> pointParams = context.getEnvironment().getPointParams();
        long s = this.getLongValue(this.start, pointParams, context);
        long e = this.getLongValue(this.end, pointParams, context);
        try {
            long value;
            Sequence seq = SequenceManager.getInstance().getSequence(this.name);
            long current = seq.getCurrent();
            if (current >= e) {
                if (current == e) {
                    if (!this.loop) throw new ExecuteException(String.format("The sequence ended. Current %s Max %s", current, e));
                    value = s;
                    if (!this.noIncrement) {
                        seq.setCurrent(value);
                    }
                } else {
                    value = s;
                    if (!this.noIncrement) {
                        seq.setCurrent(value);
                    }
                }
            } else if (current < s) {
                value = s;
                if (!this.noIncrement) {
                    seq.setCurrent(value);
                }
            } else {
                value = this.noIncrement ? current + 1L : seq.next();
            }
            context.put(this.resultKey, new InputElement(this.resultKey, this.resultTitle, Long.toString(value)));
            Action action = this.actionMap.getActionByType("success");
            if (action != null) {
                ActionContext local = new ActionContext("SimpleSequence:" + value, context, action.getSequence());
                local.execute();
                return;
            } else {
                context.execute();
                context.cancelScript();
            }
            return;
        }
        catch (Exception ex) {
            context.getEnvironment().handleError(ex);
            Action action = this.actionMap.getActionByType("error");
            if (action != null) {
                ActionContext local = new ActionContext("SimpleSequence", context, action.getSequence());
                local.execute();
                return;
            }
            context.execute();
            context.cancelScript();
        }
    }

    private long getLongValue(String value, Map<String, String> pointParams, ActionContext context) throws ExecuteException {
        if (value == null || value.isEmpty()) {
            throw new ExecuteException("Value not set");
        }
        if (value.matches("^[a-zA-Z#$]{1}.*$")) {
            if (value.startsWith("$")) {
                try {
                    return Long.parseLong(pointParams.get(value.substring(1)));
                }
                catch (Exception ex) {
                    throw new ExecuteException("An error occurred while converting the variable" + value, ex);
                }
            }
            Object o = context.get(this.name);
            if (o == null) {
                throw new ExecuteException("Variable named" + value + "not found");
            }
            if (!(o instanceof InputElement)) {
                throw new ExecuteException("Variable named" + value + "has wrong type" + o.getClass().getSimpleName());
            }
            InputElement ie = (InputElement)o;
            try {
                return Long.parseLong(ie.getValue());
            }
            catch (Exception ex) {
                throw new ExecuteException("An error occurred while converting the variable" + value, ex);
            }
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception ex) {
            throw new ExecuteException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 " + value, ex);
        }
    }
}

