/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.validator;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.advanced.actions.ExecuteException;
import ru.softlogic.input.model.advanced.actions.validator.ComplexValidator;
import ru.softlogic.input.model.advanced.configuration.RuntimeConfiguration;
import ru.softlogic.input.model.utils.FileUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LocalCapacityValidator
extends ComplexValidator {
    public static final long serialVersionUID = 0L;
    private String accountKey;
    private String function;

    public void setAccountKey(String accountKey) {
        this.accountKey = accountKey;
    }

    public String getAccountKey() {
        return this.accountKey;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ActionContext context) throws ExecuteException {
        Action act;
        String action;
        String account = ContextHelper.getStringParam(this.accountKey == null ? "account" : this.accountKey, context);
        BufferedReader reader = null;
        try {
            String line;
            String filepath = "" + RuntimeConfiguration.getInstance().getHomePath() + File.separator + "resources" + File.separator + "verify-data" + File.separator + this.function + ".data";
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filepath), "UTF-8"));
            String[] headers = null;
            boolean found = false;
            while ((line = reader.readLine()) != null) {
                int max;
                String[] split = line.split("\t");
                if (headers == null) {
                    headers = split;
                    if (headers.length >= 2) continue;
                    throw new Exception("Incorrect headers");
                }
                if (split.length != headers.length) continue;
                int n = max = split[0].length() > split[1].length() ? split[0].length() : split[1].length();
                if (account.length() > max) continue;
                StringBuilder sb = new StringBuilder(account);
                while (sb.length() < max) {
                    sb.append("0");
                }
                if (split[0].compareTo(line) > 0 || split[1].compareTo(line) < 0) continue;
                for (int i = 2; i < split.length; ++i) {
                    String[] title;
                    if (headers[i] == null || (title = headers[i].split("\\:")).length != 2) continue;
                    if (title[0].startsWith("#")) {
                        context.put(title[0], split[i]);
                        continue;
                    }
                    context.put(title[0], new InputElement(title[0], title[1], split[i]));
                }
                found = true;
                break;
            }
            action = found ? "success" : "error";
        }
        catch (Exception e) {
            try {
                action = "error";
            }
            catch (Throwable throwable) {
                FileUtil.close(reader);
                throw throwable;
            }
            FileUtil.close(reader);
        }
        FileUtil.close(reader);
        Action action2 = act = this.actionMap == null ? null : this.actionMap.getActionByType(action);
        if (act != null) {
            ActionContext local = new ActionContext("LocalCapacity:" + this.accountKey + "->" + this.function, context, act.getSequence());
            local.execute();
        } else {
            context.execute();
            context.cancelScript();
        }
    }
}

