/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.validator;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.BufferedReader;
import java.io.File;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.advanced.actions.ExecuteException;
import ru.softlogic.input.model.advanced.actions.validator.ComplexValidator;
import ru.softlogic.input.model.advanced.configuration.RuntimeConfiguration;
import ru.softlogic.input.model.advanced.messages.B;
import ru.softlogic.input.model.utils.FileUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BankAccountValidator
extends ComplexValidator {
    public static final long serialVersionUID = 0L;
    private String bikKey;
    private String accountKey;
    private String bankKey;

    public void setAccountKey(String accountKey) {
        this.accountKey = accountKey;
    }

    public void setBikKey(String bikKey) {
        this.bikKey = bikKey;
    }

    public void setBankKey(String bankKey) {
        this.bankKey = bankKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ActionContext context) throws ExecuteException {
        Action act;
        String bik = ContextHelper.getStringParam(this.bikKey == null ? "bik" : this.bikKey, context);
        String account = ContextHelper.getStringParam(this.accountKey == null ? "account" : this.accountKey, context);
        BufferedReader reader = null;
        String bank = null;
        boolean wasEx = false;
        try {
            String line;
            String filepath = RuntimeConfiguration.getInstance().getHomePath() + File.separator + "resources" + File.separator + "bik.csv";
            reader = FileUtil.createReader(filepath, "UTF-8");
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(";");
                if (split.length != 3 || !split[2].trim().equals(bik.trim())) continue;
                bank = split[1];
                break;
            }
        }
        catch (Exception e) {
            try {
                bank = null;
                wasEx = true;
            }
            catch (Throwable throwable) {
                FileUtil.close(reader);
                throw throwable;
            }
            FileUtil.close(reader);
        }
        FileUtil.close(reader);
        BicAccountVerifier bav = new BicAccountVerifier();
        if (!wasEx && bank == null) {
            act = this.getActionIfNotNull(this.actionMap, "bik_error");
        } else if (!bav.verify(bik, account, 2)) {
            act = this.getActionIfNotNull(this.actionMap, "account_error");
        } else {
            if (bank == null) {
                bank = "";
            }
            act = this.getActionIfNotNull(this.actionMap, "success");
            context.put(this.bankKey == null ? "bank" : this.bankKey, new InputElement(this.bankKey == null ? "bank" : this.bankKey, B.get("ComplexValidator.BankAccount.bank"), bank, bank, 0));
        }
        if (act != null) {
            ActionContext local = new ActionContext("bikverify:" + bik + "->" + account, context, act.getSequence());
            local.execute();
        } else {
            context.execute();
            context.cancelScript();
        }
    }

    private Action getActionIfNotNull(ActionMap actionMap, String actionName) {
        if (actionMap != null) {
            return actionMap.getActionByType(actionName);
        }
        return null;
    }

    private static final class BicAccountVerifier {
        private final int[] KOEFS = new int[]{7, 1, 3, 7, 1, 3, 7, 1, 3, 7, 1, 3, 7, 1, 3, 7, 1, 3, 7, 1, 3, 7, 1};
        public static final int RKC = 1;
        public static final int KREDIT = 2;
        public static final int KVAL = 3;

        private BicAccountVerifier() {
        }

        public boolean verify(String bic, String account, int type) throws ExecuteException {
            if (bic == null || account == null) {
                return true;
            }
            if (account.length() != 20) {
                throw new IllegalArgumentException("The length should be 20 characters");
            }
            StringBuilder sb = new StringBuilder();
            if (type == 1) {
                sb.append("0").append(bic.charAt(4)).append(5);
            } else {
                sb.append(bic.substring(6));
            }
            if (type == 3) {
                account = account.replace('A', '0').replace('B', '1').replace('C', '2').replace('E', '3').replace('H', '4').replace('K', '5').replace('M', '6').replace('P', '7').replace('T', '8').replace('X', '9');
            }
            sb.append(account.substring(0, 8)).append("0").append(account.substring(9));
            int[] mas = this.strToMas(sb.toString());
            int summ = 0;
            for (int i = 0; i < 23; ++i) {
                summ += mas[i] * this.KOEFS[i] % 10;
            }
            summ %= 10;
            summ *= 3;
            return Character.toString(account.charAt(8)).equals(Integer.toString(summ %= 10));
        }

        private int[] strToMas(String src) throws ExecuteException {
            int[] mas = new int[src.length()];
            int i = 0;
            try {
                for (i = 0; i < mas.length; ++i) {
                    mas[i] = Integer.parseInt(Character.toString(src.charAt(i)));
                }
            }
            catch (Exception ex) {
                throw new ExecuteException("Can not convert the character string:" + src + "in the position of" + i, ex);
            }
            return mas;
        }
    }
}

