/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.simple;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.NestedData;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ExecuteException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Unpack
implements ActionElement {
    public static final String TYPE_NESTED = "nested";
    public static final String TYPE_DATA = "data";
    public static final long serialVersionUID = 0L;
    private String type;
    private String key = "";
    private String elements;

    public String getKey() {
        return this.key;
    }

    public String getType() {
        return this.type;
    }

    public void setKey(String key) {
        if (key == null) {
            key = "";
        }
        this.key = key;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getElements() {
        return this.elements;
    }

    public void setElements(String elements) {
        this.elements = elements;
    }

    public String toString() {
        return "Unpack{type=" + this.type + ", key=" + this.key + '}';
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        Object dataObject = context.getData().get(this.key);
        if (TYPE_NESTED.equals(this.type)) {
            this.unpackNested(context, dataObject);
        } else if (TYPE_DATA.equals(this.type)) {
            this.unpackData(context, dataObject);
        } else {
            throw new ExecuteException("Unknown unpack type");
        }
        context.execute();
    }

    private void unpackNested(ActionContext context, Object dataObject) throws ExecuteException {
        if (!(dataObject instanceof List)) {
            throw new ExecuteException(dataObject + " is not NestedData");
        }
        List data = (List)dataObject;
        for (Data dataEntry : data) {
            this.putDataInContext(context, dataEntry);
        }
    }

    private void unpackData(ActionContext context, Object dataObject) throws ExecuteException {
        if (!(dataObject instanceof Data)) {
            throw new ExecuteException(dataObject + " is not Data");
        }
        Data dt = (Data)dataObject;
        if (this.elements == null || this.elements.trim().isEmpty()) {
            this.putDataInContext(context, dt);
        } else {
            String[] keys = this.elements.split(",");
            if (dt.getElements() != null) {
                Map<String, InputElement> dataMap = StoreHelper.convert(dt.getElements());
                String[] stringArray = keys;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String s = stringArray[i];
                    if (dataMap.get(s) == null) continue;
                    context.put(s, dataMap.get(s));
                }
            }
            if (dt.getNestedData() != null) {
                for (String s : keys) {
                    if (!s.equals(dt.getNestedData().getId())) continue;
                    context.put(s, dt.getNestedData().getData());
                }
            }
        }
    }

    private void putDataInContext(ActionContext context, Data data) {
        NestedData nestedData;
        List<InputElement> elementList = data.getElements();
        if (elementList != null) {
            for (InputElement ie : elementList) {
                context.put(ie.getKey(), ie);
            }
        }
        if ((nestedData = data.getNestedData()) != null) {
            context.put(nestedData.getId(), nestedData.getData());
        }
    }
}

