/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.simple;

import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ExecuteException;

public class TextFormatTable
implements ActionElement {
    public static final long serialVersionUID = 0L;
    private String key;
    private String template;
    private String inputData;
    private String filter;
    private String defaultValue;

    public String getInputData() {
        return this.inputData;
    }

    public String getKey() {
        return this.key;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setInputData(String inputData) {
        this.inputData = inputData;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        if (this.key == null) {
            throw new ExecuteException("Key not set");
        }
        if (this.template == null) {
            throw new ExecuteException("Template not set");
        }
        if (this.inputData == null) {
            throw new ExecuteException("InputData not set");
        }
        Set<String> keys = StoreHelper.parceTemplate(this.template);
        Object data = context.getData().get(this.inputData);
        StringBuilder sb = new StringBuilder();
        if (data instanceof List) {
            List nd = (List)data;
            for (Data d : nd) {
                String wt = this.template;
                if (d.getElements() == null || !this.isFilterCorrect(d.getElements())) continue;
                Map<String, InputElement> items = StoreHelper.convert(d.getElements());
                for (String k : keys) {
                    InputElement ie = items.get(k);
                    String value = null;
                    if (ie != null) {
                        String string = value = ie.getValueTitle() != null && !ie.getValueTitle().isEmpty() ? "" + ie.getValueTitle() : "" + ie.getValue();
                    }
                    if (value == null || value.trim().isEmpty()) {
                        value = this.defaultValue;
                    }
                    wt = wt.replace("${" + k + "}", value);
                }
                sb.append(wt);
            }
        } else {
            throw new ExecuteException("" + data + " is not NestedData");
        }
        context.put(this.key, new InputElement(this.key, "", sb.toString()));
        context.execute();
    }

    private boolean isFilterCorrect(List<InputElement> elements) {
        String localFilter = this.filter;
        if (localFilter == null || localFilter.trim().isEmpty()) {
            return true;
        }
        String[] split = localFilter.split("\\;");
        Map<String, InputElement> map = StoreHelper.convert(elements);
        for (String s : split) {
            String[] split1 = s.split("=");
            if (!map.containsKey(split1[0])) {
                return false;
            }
            if (map.get(split1[0]) == null) {
                return false;
            }
            if (!(split1.length == 1 ? map.get(split1[0]).getValue() == null || !map.get(split1[0]).getValue().trim().isEmpty() : split1.length == 2 && !split1[1].equals(map.get(split1[0]).getValue()))) continue;
            return false;
        }
        return true;
    }
}

