/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.simple;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ExecuteException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Sum
implements ActionElement {
    public static final long serialVersionUID = 0L;
    private String key;
    private String resultKey;
    private String inputData;
    private String filter;

    public String getFilter() {
        return this.filter;
    }

    public String getInputData() {
        return this.inputData;
    }

    public String getKey() {
        return this.key;
    }

    public String getResultKey() {
        return this.resultKey;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setInputData(String inputData) {
        this.inputData = inputData;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setResultKey(String resultKey) {
        this.resultKey = resultKey;
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        if (this.key == null) {
            throw new ExecuteException("Key not set");
        }
        if (this.resultKey == null) {
            throw new ExecuteException("Result key not set");
        }
        if (this.inputData == null) {
            throw new ExecuteException("InputData not set");
        }
        Object data = context.getData().get(this.inputData);
        if (!(data instanceof List)) {
            throw new ExecuteException("" + data + " is not NestedData");
        }
        float sum = 0.0f;
        List nd = (List)data;
        for (Data d : nd) {
            InputElement ie;
            Map<String, InputElement> map = StoreHelper.convert(d.getElements());
            if (d.getElements() == null || !this.isFilterCorrect(map) || (ie = map.get(this.key)) == null) continue;
            try {
                String value = ie.getValue();
                if (value == null || value.trim().isEmpty()) continue;
                sum = (float)((double)sum + Double.parseDouble(value.replace(',', '.')));
            }
            catch (NumberFormatException e) {
                throw new ExecuteException("Invalid value of the sum", e);
            }
        }
        context.put(this.resultKey, new InputElement(this.resultKey, "", Float.toString(sum)));
        context.execute();
    }

    private boolean isFilterCorrect(Map<String, InputElement> map) {
        String[] split;
        String localFilter = this.filter;
        if (localFilter == null || localFilter.trim().isEmpty()) {
            return true;
        }
        for (String s : split = localFilter.split("\\;")) {
            String[] split1 = s.split("=|(!=)");
            InputElement ie = map.get(split1[0]);
            if (ie == null) {
                return false;
            }
            String value = ie.getValue();
            if (split1.length == 1) {
                if (s.contains("!=")) {
                    return value != null && !value.trim().isEmpty();
                }
                return value != null && value.trim().isEmpty();
            }
            if (split1.length != 2) continue;
            if (s.contains("!=")) {
                return !split1[1].equals(value);
            }
            return split1[1].equals(value);
        }
        return true;
    }
}

