/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.simple;

import com.fasterxml.jackson.annotation.JsonInclude;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.advanced.actions.ExecuteException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SetSumLimit
implements ActionElement {
    public static final long serialVersionUID = 0L;
    private String key;
    private String type;
    private String target;

    public SetSumLimit() {
    }

    public SetSumLimit(String key, String type, String target) {
        this.key = key;
        this.type = type;
        this.target = target;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String toString() {
        return "SetSumLimit{key=" + this.key + ", type=" + this.type + ", target=" + this.target + '}';
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        if ("min".equals(this.target)) {
            context.put("#sum-min", this.getSum(context));
        } else if ("max".equals(this.target)) {
            context.put("#sum-max", this.getSum(context));
        } else if ("max-deposit".equals(this.target)) {
            context.put("#sum-deposit-max", this.getSum(context));
        } else if ("min-limit".equals(this.target)) {
            context.put("#sum-min-limit", this.getSum(context));
        } else {
            context.put(this.target, this.getSum(context));
        }
        context.execute();
    }

    private TransactionSum getSum(ActionContext context) throws ExecuteException {
        if ("units".equals(this.type)) {
            return new TransactionSum(ContextHelper.getFloatParam(this.key, context));
        }
        if ("decimals".equals(this.type)) {
            return new TransactionSum(ContextHelper.getIntParam(this.key, context));
        }
        throw new ExecuteException("Incorrect type of unit: " + this.type);
    }
}

