/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.simple;

import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.advanced.actions.ExecuteException;
import ru.softlogic.input.model.advanced.actions.request.CardRequestListener;

public class ReadCardTrack
implements ActionElement {
    private static final long serialVersionUID = 1L;
    private InputElement element;
    private int track;
    private ActionMap actionMap;

    public ReadCardTrack() {
    }

    public ReadCardTrack(InputElement element, int track) {
        this.element = element;
        this.track = track;
    }

    public InputElement getElement() {
        return this.element;
    }

    public void setElement(InputElement element) {
        this.element = element;
    }

    public void setActionMap(ActionMap actionMap) {
        this.actionMap = actionMap;
    }

    public String toString() {
        return "ReadCardTrack{element=" + this.element + '}';
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        if (this.element == null) {
            throw new ExecuteException("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d");
        }
        context.getEnvironment().getCardTrack(this.track, new LocalCardRequestListener(context));
    }

    private class LocalCardRequestListener
    implements CardRequestListener {
        private final ActionContext context;

        public LocalCardRequestListener(ActionContext context) {
            this.context = context;
        }

        @Override
        public void onResult(String res) {
            if (ReadCardTrack.this.actionMap == null) {
                return;
            }
            if (res != null) {
                Action act = ReadCardTrack.this.actionMap.getActionByType("success");
                if (act != null) {
                    InputElement ie = new InputElement(ReadCardTrack.this.element.getKey(), ReadCardTrack.this.element.getKeyTitle(), res, ReadCardTrack.this.element.getFlags());
                    ActionContext local = new ActionContext("Card Track Read:", this.context, act.getSequence());
                    local.put(ie.getKey(), ie);
                    local.execute();
                } else {
                    this.context.cancelScript();
                }
            } else {
                Action act = ReadCardTrack.this.actionMap.getActionByType("error");
                if (act != null) {
                    ActionContext local = new ActionContext("Card Track Read:", this.context, act.getSequence());
                    local.execute();
                } else {
                    this.context.cancelScript();
                }
            }
        }
    }
}

