/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.simple;

import com.fasterxml.jackson.annotation.JsonInclude;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ExecuteException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Modify
implements ActionElement {
    public static final long serialVersionUID = 0L;
    private static final String FLAGS_ACTION_SET = "set";
    private static final String FLAGS_ACTION_ADD = "add";
    private static final String FLAGS_ACTION_REMOVE = "remove";
    private String srcKey;
    private InputElement target;
    private InputElement value;
    private int flags;
    private String flagsAction;

    public String getSrcKey() {
        return this.srcKey;
    }

    public InputElement getTarget() {
        return this.target;
    }

    public InputElement getValue() {
        return this.value;
    }

    public void setSrcKey(String srcKey) {
        this.srcKey = srcKey;
    }

    public void setTarget(InputElement target) {
        this.target = target;
    }

    public void setValue(InputElement value) {
        this.value = value;
    }

    public Integer getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getFlagAction() {
        return this.flagsAction;
    }

    public void setFlagAction(String flagAction) {
        this.flagsAction = flagAction;
    }

    public String toString() {
        return "Modify{target=" + this.target + ", value=" + this.value + ", flags=" + this.flags + ", flagAction=" + this.flagsAction + '}';
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        if (this.srcKey == null) {
            throw new ExecuteException("Field 'src-key' not set");
        }
        if (this.target == null) {
            throw new ExecuteException("Field 'target' not set");
        }
        if (this.value == null) {
            throw new ExecuteException("Field 'value' not set");
        }
        Object obj = context.get(this.srcKey);
        if (!(obj instanceof InputElement)) {
            throw new ExecuteException("Can not convert " + this.srcKey + " to InputElement");
        }
        InputElement ie = (InputElement)obj;
        InputElement val = new InputElement();
        val.setKey(this.processField(ie.getKey(), this.target.getKey(), this.value.getKey()));
        val.setKeyTitle(this.processField(ie.getKeyTitle(), this.target.getKeyTitle(), this.value.getKeyTitle()));
        val.setValue(this.processField(ie.getValue(), this.target.getValue(), this.value.getValue()));
        val.setValueTitle(this.processField(ie.getValueTitle(), this.target.getValueTitle(), this.value.getValueTitle()));
        val.setOriginalValue(this.processField(ie.getOriginalValue(), this.target.getOriginalValue(), this.value.getOriginalValue()));
        val.setFlags(ie.getFlags());
        if (FLAGS_ACTION_ADD.equals(this.flagsAction)) {
            val.addFlag(this.flags);
        } else if (FLAGS_ACTION_REMOVE.equals(this.flagsAction)) {
            val.removeFlag(this.flags);
        } else if (FLAGS_ACTION_SET.equals(this.flagsAction)) {
            val.setFlags(this.flags);
        }
        if (ie.hasFlag(0x10000000)) {
            val.addFlag(0x10000000);
        }
        context.put(val.getKey(), val);
        context.execute();
    }

    private String processField(String src, String target, String value) throws ExecuteException {
        if (src == null) {
            return null;
        }
        if (target == null || value == null) {
            return src;
        }
        try {
            return src.replaceAll(target, value);
        }
        catch (Exception ex) {
            throw new ExecuteException("Error on modify data, src=" + src + ", target=" + target + ", value=" + value, ex);
        }
    }
}

