/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.simple;

import com.fasterxml.jackson.annotation.JsonInclude;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ExecuteException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LoadKey
implements ActionElement {
    public static final long serialVersionUID = 0L;
    private String from;
    private String key;
    private String title;
    private String titleId;
    private String keyId;
    private int flags;

    public LoadKey() {
    }

    public LoadKey(String from) {
        this.from = from;
    }

    public LoadKey(String from, String key) {
        this.from = from;
        this.key = key;
    }

    public LoadKey(String from, String key, String title, int flags) {
        this(from, key);
        this.title = title;
        this.flags = flags;
    }

    public LoadKey(String from, String key, String title, int flags, String titleId, String keyId) {
        this.from = from;
        this.key = key;
        this.title = title;
        this.titleId = titleId;
        this.keyId = keyId;
        this.flags = flags;
    }

    public String getKey() {
        return this.key;
    }

    public String getTitle() {
        return this.title;
    }

    public String getFrom() {
        return this.from;
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        InputElement value = context.getEnvironment().getValue(this.from);
        if (value != null) {
            if (this.key != null) {
                value.setKey(this.key);
            }
            if (this.title != null) {
                value.setKeyTitle(this.title);
            } else if (this.keyId != null) {
                value.setKeyTitleId(this.keyId);
            } else if (value.getKeyTitle() == null) {
                value.setKeyTitle(this.key != null ? this.key : this.from);
            }
            value.setFlags(this.flags);
            if (value.getValue() == null) {
                value.setValue("");
            }
            if (value.getValueTitle() == null) {
                value.setValueTitle("");
            }
            context.put(this.key != null ? this.key : this.from, value);
        }
        context.execute();
    }

    public int hashCode() {
        int hash = 3;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoadKey other = (LoadKey)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        return this.flags == other.flags;
    }

    public String toString() {
        return "LoadKey{key=" + this.key + ", title=" + this.title + ", from=" + this.from + ", flags=" + this.flags + '}';
    }
}

