/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.simple;

import com.fasterxml.jackson.annotation.JsonInclude;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ExecuteException;
import ru.softlogic.input.model.advanced.expression.calculator.CalculateException;
import ru.softlogic.input.model.advanced.expression.calculator.ExpressionCalculator;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Goto
implements ActionElement {
    public static final long serialVersionUID = 0L;
    private String expression;
    private String target;
    private String targetElse;

    public Goto() {
    }

    public Goto(String target) {
        this.target = target;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTargetElse() {
        return this.targetElse;
    }

    public void setTargetElse(String targetElse) {
        this.targetElse = targetElse;
    }

    public String toString() {
        return "Goto{expression=" + this.expression + ", target=" + this.target + ", targetElse=" + this.targetElse + '}';
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        if (this.expression != null) {
            try {
                Object result = ExpressionCalculator.calculate(this.expression, context.getData());
                if (!(result instanceof Boolean)) {
                    throw new ExecuteException("Incorrect result type: " + result.getClass().getName());
                }
                Boolean bAnswer = (Boolean)result;
                context.finishScript(bAnswer != false ? this.target : this.targetElse);
            }
            catch (CalculateException ex) {
                throw new ExecuteException(ex.getMessage(), ex);
            }
        } else {
            context.finishScript(this.target);
        }
    }
}

