/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.simple;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ExecuteException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DateUtil
implements ActionElement {
    public static final long serialVersionUID = 0L;
    private final String srcKey;
    private final String targetKey;
    private final String inputFormat;
    private final String outputFormat;
    private final int field;
    private final int amount;

    @JsonCreator
    public DateUtil(@JsonProperty(value="srcKey") String srcKey, @JsonProperty(value="targetKey") String targetKey, @JsonProperty(value="inputForm") String inputFormat, @JsonProperty(value="outputForm") String outputFormat, @JsonProperty(value="field") int field, @JsonProperty(value="amount") int amount) {
        this.srcKey = srcKey;
        this.targetKey = targetKey;
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.field = field;
        this.amount = amount;
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        Object obj = context.get(this.srcKey);
        if (!(obj instanceof InputElement)) {
            throw new ExecuteException("Can not convert " + this.srcKey + " to InputElement");
        }
        InputElement ie = (InputElement)obj;
        if (ie.getValue() == null) {
            throw new ExecuteException("Value not set");
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(this.inputFormat);
            GregorianCalendar c1 = new GregorianCalendar();
            c1.setTime(sdf.parse(ie.getValue()));
            ((Calendar)c1).add(this.field, this.amount);
            sdf = new SimpleDateFormat(this.outputFormat);
            InputElement val = new InputElement();
            val.setKey(this.targetKey);
            val.setKeyTitle(ie.getKeyTitle());
            val.setValue(sdf.format(c1.getTime()));
            val.setValueTitle(sdf.format(c1.getTime()));
            context.put(val.getKey(), val);
            context.execute();
        }
        catch (Exception ex) {
            throw new ExecuteException("DateUtil. Date parse error: ", ex);
        }
    }

    public String getSrcKey() {
        return this.srcKey;
    }

    public String getTargetKey() {
        return this.targetKey;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public int getField() {
        return this.field;
    }

    public int getAmount() {
        return this.amount;
    }
}

