/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.simple;

import com.fasterxml.jackson.annotation.JsonInclude;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.AdvancedCommissionCalculator;
import ru.softlogic.input.model.advanced.Rounding;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.advanced.actions.ExecuteException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CalcIncome
implements ActionElement {
    public static final long serialVersionUID = 0L;
    private String from;
    private String key;
    private String title;
    private Rounding rounding;

    public CalcIncome() {
    }

    public CalcIncome(String from, String key, String title, Rounding rounding) {
        this.from = from;
        this.key = key;
        this.title = title;
        this.rounding = rounding;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Rounding getRounding() {
        return this.rounding;
    }

    public void setRounding(Rounding rounding) {
        this.rounding = rounding;
    }

    public String toString() {
        return "CalcIncome{from=" + this.from + ", key=" + this.key + ", title=" + this.title + ", rounding=" + (Object)((Object)this.rounding) + '}';
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        AdvancedCommissionCalculator calculator = context.getEnvironment().getCommissionCalculator();
        if (calculator != null) {
            float floatParam = ContextHelper.getFloatParam(this.from, context);
            int sum = Math.round(floatParam * 100.0f);
            Double calcSumm = calculator.calculateIncomeSum((double)sum / 100.0, this.rounding);
            String ieTitle = this.title != null ? this.title : this.key;
            String ieValue = String.format("%.2f", calcSumm);
            InputElement inputElement = new InputElement(this.key, ieTitle, ieValue);
            context.put(this.key, ContextHelper.inheritFlagReceivedFromServer(inputElement, this.from, context));
        }
        context.execute();
    }
}

