/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.script;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.AsyncTask;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.advanced.configuration.RuntimeConfiguration;

public class ExecuteScriptTask
implements AsyncTask {
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private static final String[] extension = OS.contains("win") ? new String[]{".cmd", ".bat"} : new String[]{".sh", ""};
    private static final long serialVersionUID = 1L;
    private final ActionContext context;
    private final ActionMap actionMap;
    private final String fileName;
    private final List<String> params;

    public ExecuteScriptTask(ActionContext context, ActionMap actionMap, String fileName, List<String> params) {
        this.fileName = fileName;
        this.context = context;
        this.params = params;
        this.actionMap = actionMap;
    }

    @Override
    public Object execute() {
        try {
            File file = this.searchScriptFile(this.fileName);
            this.params.add(0, file.getAbsolutePath());
            ProcessBuilder pb = new ProcessBuilder(this.params);
            pb.directory(file.getParentFile());
            Process process = pb.start();
            return process.waitFor();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return ex;
        }
        catch (IOException ex) {
            return ex;
        }
    }

    @Override
    public void onResult(Object result) {
        if (result instanceof Exception) {
            Exception ex = (Exception)result;
            Action action = this.actionMap.getActionByType("exception");
            if (action != null) {
                ActionContext local = new ActionContext(this.getContextName(), this.context, action.getSequence());
                local.setTransparent(true);
                local.execute();
            } else {
                this.context.getEnvironment().showError(new Exception("Error script execute" + this.fileName + "(" + this.params + ")", ex));
                this.context.cancelScript();
            }
        } else {
            int exitCode = (Integer)result;
            if (exitCode == 0) {
                Action action = this.actionMap.getActionByType("success");
                if (action != null) {
                    ActionContext local = new ActionContext(this.getContextName(), this.context, action.getSequence());
                    local.execute();
                } else {
                    this.context.execute();
                }
            } else {
                Action action = this.actionMap.getActionByType("error");
                if (action != null) {
                    ActionContext local = new ActionContext(this.getContextName(), this.context, action.getSequence());
                    InputElement inputElement = new InputElement("#error-code", "#error-code", Integer.toString(exitCode));
                    local.put(inputElement.getKey(), inputElement);
                    local.execute();
                } else {
                    this.context.cancelScript();
                }
            }
        }
    }

    private String getContextName() {
        return "execute script:" + this.fileName + "(" + this.params + ")";
    }

    private File searchScriptFile(String fileName) throws FileNotFoundException {
        File binPath = RuntimeConfiguration.getInstance().getBinPath();
        for (String ext : extension) {
            File file = new File(binPath, fileName + ext);
            if (!file.exists() || !file.canRead() || !file.canExecute()) continue;
            return file;
        }
        throw new FileNotFoundException();
    }
}

