/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.loop;

import java.util.List;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ExecuteException;

public class LoopIteration
implements ActionElement {
    public static final long serialVersionUID = 0L;
    private final int index;
    private final Object element;
    private final List<ActionElement> body;
    private final long sleep;

    public LoopIteration(int index, Object element, List<ActionElement> body, long sleep) {
        this.index = index;
        this.element = element;
        this.body = body;
        this.sleep = sleep;
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        String contextName = "for[0, " + this.index + "]";
        ActionContext local = new ActionContext(contextName, context, this.body);
        local.put("#for-index", new InputElement("#for_index", "#for_index", Integer.toString(this.index)));
        if (this.element != null) {
            local.put("#for-element", this.element);
        }
        local.execute();
        context.remove("#for-index");
        if (this.element != null) {
            context.remove("#for-element");
        }
        if (this.sleep > 0L) {
            try {
                Thread.sleep(this.sleep);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

